/*
 * Decompiled with CFR 0.152.
 */
package com.dewarder.holdinglibrary;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.dewarder.holdinglibrary.HoldingButtonLayoutListener;
import com.dewarder.holdinglibrary.HoldingButtonTouchListener;
import com.dewarder.holdinglibrary.HoldingDrawable;
import com.dewarder.holdinglibrary.HoldingDrawableListener;
import com.dewarder.holdinglibrary.R;
import java.util.ArrayList;
import java.util.List;

public class HoldingButtonLayout
extends FrameLayout {
    private int mHoldingViewId = -1;
    private View mHoldingView;
    private Rect mHoldingViewRect = new Rect();
    private float mCancelOffset = 0.3f;
    private float mDeltaX;
    private View mHoldingCircle;
    private HoldingDrawable mHoldingDrawable;
    private int[] mOffset = new int[2];
    private int[] mViewLocation = new int[2];
    private int[] mHoldingViewLocation = new int[2];
    private Direction mDirection = Direction.START;
    private boolean mAnimateHoldingView = true;
    private boolean mButtonEnabled = true;
    private boolean mIsCancel = false;
    private boolean mIsExpanded = false;
    private HoldingButtonTouchListener mTouchListener = new SimpleHoldingButtonTouchListener();
    private final DrawableListener mDrawableListener = new DrawableListener();
    private final List<HoldingButtonLayoutListener> mListeners = new ArrayList<HoldingButtonLayoutListener>();

    public HoldingButtonLayout(@NonNull Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public HoldingButtonLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public HoldingButtonLayout(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, 0, 0);
    }

    @TargetApi(value=21)
    public HoldingButtonLayout(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mHoldingDrawable = new HoldingDrawable();
        this.mHoldingDrawable.setListener(this.mDrawableListener);
        if (attrs != null) {
            TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HoldingButtonLayout, defStyleAttr, defStyleRes);
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_enabled)) {
                this.setButtonEnabled(array.getBoolean(R.styleable.HoldingButtonLayout_hbl_enabled, true));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_radius)) {
                this.mHoldingDrawable.setRadius(array.getDimensionPixelSize(R.styleable.HoldingButtonLayout_hbl_radius, 280));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_icon)) {
                this.setIcon(array.getResourceId(R.styleable.HoldingButtonLayout_hbl_icon, 0));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_cancel_icon)) {
                int drawableRes = array.getResourceId(R.styleable.HoldingButtonLayout_hbl_cancel_icon, 0);
                this.mHoldingDrawable.setCancelIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)drawableRes));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_offset_x)) {
                this.mOffset[0] = array.getDimensionPixelSize(R.styleable.HoldingButtonLayout_hbl_offset_x, 0);
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_offset_y)) {
                this.mOffset[1] = array.getDimensionPixelSize(R.styleable.HoldingButtonLayout_hbl_offset_y, 0);
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_holding_view)) {
                this.mHoldingViewId = array.getResourceId(R.styleable.HoldingButtonLayout_hbl_holding_view, -1);
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_animate_holding_view)) {
                this.mAnimateHoldingView = array.getBoolean(R.styleable.HoldingButtonLayout_hbl_animate_holding_view, true);
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_color)) {
                this.mHoldingDrawable.setColor(array.getColor(R.styleable.HoldingButtonLayout_hbl_color, 0));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_cancel_color)) {
                this.mHoldingDrawable.setCancelColor(array.getColor(R.styleable.HoldingButtonLayout_hbl_cancel_color, 0));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_second_radius)) {
                this.mHoldingDrawable.setSecondRadius(array.getDimension(R.styleable.HoldingButtonLayout_hbl_second_radius, 0.0f));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_second_alpha)) {
                float alphaMultiplier = array.getFloat(R.styleable.HoldingButtonLayout_hbl_second_alpha, 1.0f);
                if (alphaMultiplier < 0.0f && alphaMultiplier > 1.0f) {
                    throw new IllegalStateException("Second alpha value must be between 0 and 1");
                }
                this.mHoldingDrawable.setSecondAlpha((int)(255.0f * alphaMultiplier));
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_cancel_offset)) {
                float cancelOffset = array.getFloat(R.styleable.HoldingButtonLayout_hbl_cancel_offset, 1.0f);
                if (cancelOffset < 0.0f && cancelOffset > 1.0f) {
                    throw new IllegalStateException("Cancel offset must be between 0 and 1");
                }
                this.mCancelOffset = cancelOffset;
            }
            if (array.hasValue(R.styleable.HoldingButtonLayout_hbl_direction)) {
                int flag = array.getInt(R.styleable.HoldingButtonLayout_hbl_direction, 0);
                this.mDirection = Direction.fromFlag(flag);
            }
            array.recycle();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        switch (action) {
            case 0: {
                return this.isButtonEnabled() && this.isViewTouched(this.mHoldingView, ev);
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        switch (action) {
            case 0: {
                if (this.isButtonEnabled() && this.isViewTouched(this.mHoldingView, event) && this.shouldInterceptAnimation()) {
                    this.mHoldingView.getLocationInWindow(this.mHoldingViewLocation);
                    this.getLocationInWindow(this.mViewLocation);
                    int centerX = this.mHoldingViewLocation[0] + this.mHoldingView.getWidth() / 2;
                    int centerY = this.mHoldingViewLocation[1] + this.mHoldingView.getHeight() / 2;
                    float translationX = (float)centerX - (float)this.mHoldingCircle.getWidth() / 2.0f + (float)this.mDirection.getOffsetX(this.mOffset[0]);
                    float translationY = (float)centerY - (float)this.mHoldingCircle.getHeight() / 2.0f + (float)this.mOffset[1];
                    this.mHoldingCircle.setTranslationX(translationX);
                    this.mHoldingCircle.setTranslationY(translationY);
                    this.mDeltaX = event.getRawX() - (float)centerX - (float)this.mDirection.getOffsetX(this.mOffset[0]);
                    this.mHoldingDrawable.expand();
                    this.mIsCancel = false;
                    this.mIsExpanded = true;
                    return true;
                }
            }
            case 2: {
                if (this.mIsExpanded) {
                    float circleCenterX = this.mHoldingCircle.getWidth() / 2;
                    float x = event.getRawX() - this.mDeltaX - circleCenterX;
                    float slideOffset = this.mDirection.getSlideOffset(x, circleCenterX, this.mViewLocation, this.getWidth(), this.mHoldingViewLocation, this.mHoldingView.getWidth(), this.mOffset);
                    if (slideOffset >= 0.0f && slideOffset <= 1.0f) {
                        this.mHoldingCircle.setX(x);
                        this.mIsCancel = slideOffset >= this.mCancelOffset;
                        this.mHoldingDrawable.setCancel(this.mIsCancel);
                        this.notifyOnOffsetChanged(slideOffset, this.mIsCancel);
                    }
                    return true;
                }
            }
            case 1: {
                if (!this.mIsExpanded) break;
                this.submit();
                return true;
            }
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getDecorView().addView(this.mHoldingCircle, this.mHoldingDrawable.getIntrinsicWidth(), this.mHoldingDrawable.getIntrinsicHeight());
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mHoldingView == null && this.mHoldingViewId != -1) {
            this.mHoldingView = this.findViewById(this.mHoldingViewId);
        }
        if (this.mHoldingView == null) {
            throw new IllegalStateException("Holding view doesn't set. Call setHoldingView before inflate");
        }
        this.mHoldingCircle = new View(this.getContext());
        this.mHoldingCircle.setVisibility(4);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mHoldingCircle.setBackground((Drawable)this.mHoldingDrawable);
        } else {
            this.mHoldingCircle.setBackgroundDrawable((Drawable)this.mHoldingDrawable);
        }
    }

    protected ViewGroup getDecorView() {
        View decor;
        if (this.getContext() instanceof Activity && (decor = ((Activity)this.getContext()).getWindow().getDecorView()) instanceof ViewGroup) {
            return (ViewGroup)decor;
        }
        HoldingButtonLayout view = this;
        while (view.getParent() != null && view.getParent() instanceof ViewGroup) {
            view = (ViewGroup)view.getParent();
        }
        return view;
    }

    public void setTouchListener(@NonNull HoldingButtonTouchListener listener) {
        this.mTouchListener = listener;
    }

    public void addListener(HoldingButtonLayoutListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(HoldingButtonLayoutListener listener) {
        this.mListeners.remove(listener);
    }

    private boolean shouldInterceptAnimation() {
        return this.mTouchListener.onHoldingViewTouched();
    }

    private boolean isViewTouched(View view, MotionEvent event) {
        view.getDrawingRect(this.mHoldingViewRect);
        view.getLocationOnScreen(this.mHoldingViewLocation);
        this.mHoldingViewRect.offset(this.mHoldingViewLocation[0], this.mHoldingViewLocation[1]);
        return this.mHoldingViewRect.contains((int)event.getRawX(), (int)event.getRawY());
    }

    public void cancel() {
        if (this.mIsExpanded) {
            this.mIsCancel = true;
            this.submit();
        }
    }

    public void submit() {
        if (this.mIsExpanded) {
            this.mHoldingDrawable.collapse();
            this.mIsExpanded = false;
        }
    }

    public boolean isButtonEnabled() {
        return this.mButtonEnabled;
    }

    public void setButtonEnabled(boolean enabled) {
        this.mButtonEnabled = enabled;
    }

    @ColorInt
    public int getColor() {
        return this.mHoldingDrawable.getColor();
    }

    public void setColor(@ColorInt int color) {
        this.mHoldingDrawable.setColor(color);
    }

    @ColorInt
    public int getCancelColor() {
        return this.mHoldingDrawable.getCancelColor();
    }

    public void setCancelColor(@ColorInt int color) {
        this.mHoldingDrawable.setCancelColor(color);
    }

    @FloatRange(from=0.0, to=1.0)
    public float getCancelOffset() {
        return this.mCancelOffset;
    }

    public void setCancelOffset(@FloatRange(from=0.0, to=1.0) float offset) {
        this.mCancelOffset = offset;
    }

    public float getRadius() {
        return this.mHoldingDrawable.getRadius();
    }

    public void setRadius(float radius) {
        this.mHoldingDrawable.setRadius(radius);
    }

    public float getSecondRadius() {
        return this.mHoldingDrawable.getSecondRadius();
    }

    public void setSecondRadius(float radius) {
        this.mHoldingDrawable.setSecondRadius(radius);
    }

    public void setIcon(@DrawableRes int drawableRes) {
        this.setIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)drawableRes));
    }

    public void setIcon(Bitmap bitmap) {
        this.mHoldingDrawable.setIcon(bitmap);
    }

    public View getHoldingView() {
        return this.mHoldingView;
    }

    public void setHoldingView(View holdingView) {
        this.mHoldingView = holdingView;
    }

    public Direction getDirection() {
        return this.mDirection;
    }

    public void setDirection(Direction direction) {
        this.mDirection = direction;
    }

    public void setAnimateHoldingView(boolean animate) {
        this.mAnimateHoldingView = animate;
    }

    public boolean isAnimateHoldingView() {
        return this.mAnimateHoldingView;
    }

    public int getOffsetX() {
        return this.mOffset[0];
    }

    public void setOffsetX(int offsetX) {
        this.mOffset[0] = offsetX;
    }

    public int getOffsetY() {
        return this.mOffset[1];
    }

    public void setOffsetY(int offsetY) {
        this.mOffset[1] = offsetY;
    }

    private void notifyOnBeforeExpand() {
        for (HoldingButtonLayoutListener listener : this.mListeners) {
            listener.onBeforeExpand();
        }
    }

    private void notifyOnBeforeCollapse() {
        for (HoldingButtonLayoutListener listener : this.mListeners) {
            listener.onBeforeCollapse();
        }
    }

    private void notifyOnExpand() {
        for (HoldingButtonLayoutListener listener : this.mListeners) {
            listener.onExpand();
        }
    }

    private void notifyOnCollapse(boolean isCancel) {
        for (HoldingButtonLayoutListener listener : this.mListeners) {
            listener.onCollapse(isCancel);
        }
    }

    private void notifyOnOffsetChanged(float offset, boolean isCancel) {
        for (HoldingButtonLayoutListener listener : this.mListeners) {
            listener.onOffsetChanged(offset, isCancel);
        }
    }

    public static enum Direction {
        START(0){

            @Override
            int getOffsetX(int offsetX) {
                return offsetX;
            }

            @Override
            float getSlideOffset(float x, float circleCenterX, int[] viewLocation, int viewWidth, int[] holdingViewLocation, int holdingViewWidth, int[] offset) {
                float holdingViewCenterX = holdingViewLocation[0] + holdingViewWidth / 2;
                float minX = (float)viewLocation[0] + circleCenterX;
                return (x + circleCenterX - holdingViewCenterX - (float)offset[0]) / (minX - holdingViewCenterX);
            }
        }
        ,
        END(1){

            @Override
            int getOffsetX(int offsetX) {
                return -offsetX;
            }

            @Override
            float getSlideOffset(float x, float circleCenterX, int[] viewLocation, int viewWidth, int[] holdingViewLocation, int holdingViewWidth, int[] offset) {
                float holdingViewCenterX = holdingViewLocation[0] + holdingViewWidth / 2;
                float maxX = (float)(viewLocation[0] + viewWidth) - circleCenterX;
                return (x + circleCenterX - holdingViewCenterX + (float)offset[0]) / (maxX - holdingViewCenterX);
            }
        };

        private final int mFlag;

        private Direction(int flag) {
            this.mFlag = flag;
        }

        abstract int getOffsetX(int var1);

        abstract float getSlideOffset(float var1, float var2, int[] var3, int var4, int[] var5, int var6, int[] var7);

        public static Direction fromFlag(int flag) {
            for (Direction direction : Direction.values()) {
                if (direction.mFlag != flag) continue;
                return direction;
            }
            throw new IllegalStateException("There is no direction with flag " + flag);
        }
    }

    private class DrawableListener
    implements HoldingDrawableListener {
        private DrawableListener() {
        }

        @Override
        public void onBeforeExpand() {
            HoldingButtonLayout.this.notifyOnBeforeExpand();
            HoldingButtonLayout.this.mHoldingDrawable.reset();
            HoldingButtonLayout.this.mHoldingCircle.setVisibility(0);
            if (HoldingButtonLayout.this.mAnimateHoldingView) {
                HoldingButtonLayout.this.mHoldingView.setVisibility(4);
            }
        }

        @Override
        public void onBeforeCollapse() {
            HoldingButtonLayout.this.notifyOnBeforeCollapse();
        }

        @Override
        public void onExpand() {
            HoldingButtonLayout.this.notifyOnExpand();
        }

        @Override
        public void onCollapse() {
            HoldingButtonLayout.this.notifyOnCollapse(HoldingButtonLayout.this.mIsCancel);
            HoldingButtonLayout.this.mHoldingCircle.setVisibility(8);
            if (HoldingButtonLayout.this.mAnimateHoldingView) {
                HoldingButtonLayout.this.mHoldingView.setAlpha(0.0f);
                HoldingButtonLayout.this.mHoldingView.setScaleY(0.8f);
                HoldingButtonLayout.this.mHoldingView.setVisibility(0);
                HoldingButtonLayout.this.mHoldingView.animate().alpha(1.0f).scaleY(1.0f).setDuration((long)HoldingButtonLayout.this.getResources().getInteger(0x10E0000)).start();
            }
        }
    }

    private class SimpleHoldingButtonTouchListener
    implements HoldingButtonTouchListener {
        private SimpleHoldingButtonTouchListener() {
        }

        @Override
        public boolean onHoldingViewTouched() {
            return true;
        }
    }
}

