/*
 * Decompiled with CFR 0.152.
 */
package com.devsoap.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyServerRunner {
    public static final String SERVER_STARTING_TOKEN = "Jetty starting";
    public static final String SERVER_STARTED_TOKEN = "Jetty started";
    public static final String SERVER_STOPPING_TOKEN = "Jetty stopping";
    public static final String SERVER_STOPPED_TOKEN = "Jetty stopped";
    public static final String SERVER_FAILED_TOKEN = "Jetty error";

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        String webAppDir = args[1];
        List<String> classesDirs = Arrays.asList(args[2].split(","));
        String resourcesDir = args[3];
        ArrayList<String> resources = new ArrayList<String>();
        if (new File(webAppDir).exists()) {
            resources.add(webAppDir);
        }
        if (System.getProperty("org.eclipse.jetty.LEVEL") == null || System.getProperty("org.eclipse.jetty.LEVEL").equals("")) {
            System.setProperty("org.eclipse.jetty.LEVEL", "INFO");
        }
        Server server = new Server(port);
        WebAppContext handler = new WebAppContext();
        server.setHandler((Handler)handler);
        handler.setContextPath("/");
        handler.setBaseResource(Resource.newResource((String)webAppDir));
        handler.setParentLoaderPriority(true);
        handler.setExtraClasspath(String.join((CharSequence)";", classesDirs) + ";" + resourcesDir);
        handler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/build/classes/.*");
        handler.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new WebInfConfiguration(), new PlusConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration()});
        handler.setClassLoader((ClassLoader)new WebAppClassLoader(JettyServerRunner.class.getClassLoader(), (WebAppClassLoader.Context)handler));
        server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarting(LifeCycle event) {
                Logger.getLogger(JettyServerRunner.class.getName()).info(JettyServerRunner.SERVER_STARTING_TOKEN);
            }

            public void lifeCycleStarted(LifeCycle event) {
                Logger.getLogger(JettyServerRunner.class.getName()).info(JettyServerRunner.SERVER_STARTED_TOKEN);
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
                Logger.getLogger(JettyServerRunner.class.getName()).info(JettyServerRunner.SERVER_FAILED_TOKEN);
            }

            public void lifeCycleStopping(LifeCycle event) {
                Logger.getLogger(JettyServerRunner.class.getName()).info(JettyServerRunner.SERVER_STOPPING_TOKEN);
            }

            public void lifeCycleStopped(LifeCycle event) {
                Logger.getLogger(JettyServerRunner.class.getName()).info(JettyServerRunner.SERVER_STOPPED_TOKEN);
            }
        });
        server.start();
        server.join();
    }
}

