/*
 * Decompiled with CFR 0.152.
 */
package com.devsoap.plugin;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class LibSassCompiler {
    public static void main(String[] args) throws Exception {
        File sourceMapFile;
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        if (!(sourceMapFile = new File(args[1] + ".map")).exists()) {
            sourceMapFile.createNewFile();
        }
        File unpackedThemes = new File(args[2]);
        File unpackedInputFile = Paths.get(unpackedThemes.getCanonicalPath(), inputFile.getParentFile().getName(), inputFile.getName()).toFile();
        Compiler compiler = new Compiler();
        Options options = new Options();
        try {
            Output output = compiler.compileFile(unpackedInputFile.toURI(), outputFile.toURI(), options);
            FileUtils.write((File)outputFile, (CharSequence)output.getCss(), (String)StandardCharsets.UTF_8.name());
            FileUtils.write((File)sourceMapFile, (CharSequence)output.getSourceMap(), (String)StandardCharsets.UTF_8.name());
        }
        catch (CompilationException e) {
            outputFile.delete();
            sourceMapFile.delete();
            throw e;
        }
    }
}

