/*
 * Decompiled with CFR 0.152.
 */
package com.devsoap.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.archive.ScatteredArchive;

public class PayaraServerRunner {
    private static final Logger LOGGER = Logger.getLogger(PayaraServerRunner.class.getName());

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        String webAppDir = args[1];
        List<String> classesDirs = Arrays.asList(args[2].split(","));
        String resourcesDir = args[3];
        Level logLevel = Level.parse(args[4]);
        String name = args[5];
        String workdir = args[6];
        String[] dependencies = new String(Files.readAllBytes(Paths.get(workdir + "/classpath.txt", new String[0])), StandardCharsets.UTF_8).split(";");
        LOGGER.log(Level.CONFIG, "Configuring logger log levels to " + logLevel);
        Logger.getLogger("").getHandlers()[0].setLevel(logLevel);
        Logger.getLogger("javax.enterprise.system.tools.deployment").setLevel(logLevel);
        Logger.getLogger("javax.enterprise.system").setLevel(logLevel);
        LOGGER.log(Level.INFO, "Starting Payara web server...");
        try {
            BootstrapProperties bootstrap = new BootstrapProperties();
            GlassFishRuntime runtime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrap, (ClassLoader)PayaraServerRunner.class.getClass().getClassLoader());
            GlassFishProperties glassfishProperties = new GlassFishProperties();
            glassfishProperties.setPort("http-listener", port);
            LOGGER.log(Level.INFO, "Running on port " + port);
            GlassFish glassfish = runtime.newGlassFish(glassfishProperties);
            glassfish.start();
            LOGGER.log(Level.INFO, "Payara started, assembling web application");
            Deployer deployer = glassfish.getDeployer();
            ScatteredArchive archive = new ScatteredArchive(name, ScatteredArchive.Type.WAR, new File(webAppDir));
            classesDirs.forEach(dir -> {
                File classes = new File((String)dir);
                if (classes.exists()) {
                    try {
                        archive.addClassPath(classes);
                        LOGGER.log(Level.INFO, "Added class dir " + dir);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Failed to add class dir " + dir, e);
                    }
                }
            });
            File resources = new File(resourcesDir);
            if (resources.exists()) {
                archive.addClassPath(new File(resourcesDir));
                LOGGER.log(Level.INFO, "Added " + resourcesDir);
            }
            for (String dependency : dependencies) {
                File jar = new File(dependency);
                if (!jar.exists()) continue;
                archive.addClassPath(new File(dependency));
            }
            LOGGER.log(Level.INFO, "Added dependencies listed in " + Paths.get(workdir + "/classpath.txt", new String[0]));
            String tmp = System.getProperty("java.io.tmpdir");
            System.setProperty("java.io.tmpdir", workdir);
            URI archiveURI = archive.toURI();
            System.setProperty("java.io.tmpdir", tmp);
            deployer.deploy(archiveURI, new String[]{"--contextroot="});
            LOGGER.log(Level.INFO, "Web application located at " + archiveURI + " deployed.");
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to start Payara server", ex);
            throw ex;
        }
    }
}

