/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.text;

import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.util.TextUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

class TextProducerInternal {
    private static final String LOREM_IPSUM = "loremIpsum";
    private static final String TEXT = "text";
    private static final String ALPHABET = "alphabet";
    private static final int WORD_COUNT_PRECISION_IN_SENTENCE = 6;
    private final BaseProducer baseProducer;
    private final String loremIpsum;
    private final String text;
    private final List<String> words;
    private final String alphabet;
    private final int maxAlphabetIndex;
    private final List<String> latinWords;

    @Inject
    public TextProducerInternal(DataMaster dataMaster, BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
        this.loremIpsum = dataMaster.getString(LOREM_IPSUM);
        this.text = dataMaster.getString(TEXT);
        this.words = Arrays.asList(StringUtils.split((String)this.text, (char)' '));
        this.latinWords = Arrays.asList(StringUtils.split((String)this.loremIpsum, (char)' '));
        this.alphabet = dataMaster.getString(ALPHABET);
        this.maxAlphabetIndex = this.alphabet.length() - 1;
    }

    public String loremIpsum() {
        return this.loremIpsum;
    }

    public String rawWords(List<String> words, int count, int precision) {
        List<String> result = this.readRawWords(words, count, precision);
        return TextUtils.joinWithSpace(result);
    }

    public String cleanLatinWords(int count) {
        return this.cleanWords(this.latinWords, count);
    }

    public String cleanWords(int count) {
        return this.cleanWords(this.words, count);
    }

    private String cleanWords(List<String> words, int count) {
        ArrayList result = Lists.newArrayList();
        for (String part : this.readRawWords(words, count, 0)) {
            result.add(StringUtils.uncapitalize((String)StringUtils.replaceChars((String)part, (String)"., ", (String)"")));
        }
        return TextUtils.joinWithSpace(result);
    }

    public String randomString(int charsCount) {
        StringBuilder sb = new StringBuilder(charsCount);
        for (int i = 0; i < charsCount; ++i) {
            sb.append(this.alphabet.charAt(this.baseProducer.randomInt(this.maxAlphabetIndex)));
        }
        return sb.toString();
    }

    private List<String> readRawWords(List<String> words, int count, int precision) {
        return this.baseProducer.randomElements(words, this.baseProducer.randomBetween(count, count + precision));
    }

    public String text() {
        return this.text;
    }

    public String sentence(int wordCount) {
        return this.sentence(this.words, wordCount);
    }

    public String latinSentence(int wordCount) {
        return this.sentence(this.latinWords, wordCount);
    }

    private String sentence(List<String> words, int wordCount) {
        String randomWords = this.rawWords(words, wordCount, 6);
        ArrayList sentences = Lists.newArrayList();
        for (String sentence : Splitter.on((String)". ").split((CharSequence)randomWords)) {
            sentences.add(StringUtils.capitalize((String)sentence));
        }
        String sentence = StringUtils.capitalize((String)Joiner.on((String)". ").join((Iterable)sentences));
        if (!StringUtils.endsWith((CharSequence)(sentence = StringUtils.removeEnd((String)sentence, (String)",")), (CharSequence)".")) {
            sentence = sentence + ".";
        }
        return sentence;
    }
}

