/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.person;

import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.DateProducer;
import com.devskiller.jfairy.producer.TimeProvider;
import com.devskiller.jfairy.producer.company.Company;
import com.devskiller.jfairy.producer.company.CompanyFactory;
import com.devskiller.jfairy.producer.company.CompanyProperties;
import com.devskiller.jfairy.producer.person.Address;
import com.devskiller.jfairy.producer.person.AddressProvider;
import com.devskiller.jfairy.producer.person.CompanyEmailProvider;
import com.devskiller.jfairy.producer.person.Country;
import com.devskiller.jfairy.producer.person.EmailProvider;
import com.devskiller.jfairy.producer.person.NationalIdentificationNumberFactory;
import com.devskiller.jfairy.producer.person.NationalIdentificationNumberProperties;
import com.devskiller.jfairy.producer.person.NationalIdentityCardNumberProvider;
import com.devskiller.jfairy.producer.person.PassportNumberProvider;
import com.devskiller.jfairy.producer.person.Person;
import com.devskiller.jfairy.producer.person.PersonProperties;
import com.devskiller.jfairy.producer.person.PersonProvider;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultPersonProvider
implements PersonProvider {
    protected Person.Sex sex;
    protected String telephoneNumberFormat;
    protected Integer age;
    protected LocalDate dateOfBirth;
    protected Company company;
    protected Address address;
    protected String firstName;
    protected String middleName;
    protected String lastName;
    protected String email;
    protected String username;
    protected String telephoneNumber;
    protected String password;
    protected String companyEmail;
    protected String nationalIdentityCardNumber;
    protected String nationalIdentificationNumber;
    protected String passportNumber;
    protected Country nationality;
    protected final DataMaster dataMaster;
    protected final DateProducer dateProducer;
    protected final BaseProducer baseProducer;
    protected final NationalIdentificationNumberFactory nationalIdentificationNumberFactory;
    protected final NationalIdentityCardNumberProvider nationalIdentityCardNumberProvider;
    protected final AddressProvider addressProvider;
    protected final CompanyFactory companyFactory;
    protected final TimeProvider timeProvider;
    protected final PassportNumberProvider passportNumberProvider;

    @Inject
    public DefaultPersonProvider(DataMaster dataMaster, DateProducer dateProducer, BaseProducer baseProducer, NationalIdentificationNumberFactory nationalIdentificationNumberFactory, NationalIdentityCardNumberProvider nationalIdentityCardNumberProvider, AddressProvider addressProvider, CompanyFactory companyFactory, PassportNumberProvider passportNumberProvider, TimeProvider timeProvider, PersonProperties.PersonProperty ... personProperties) {
        this.dataMaster = dataMaster;
        this.dateProducer = dateProducer;
        this.baseProducer = baseProducer;
        this.nationalIdentificationNumberFactory = nationalIdentificationNumberFactory;
        this.nationalIdentityCardNumberProvider = nationalIdentityCardNumberProvider;
        this.addressProvider = addressProvider;
        this.passportNumberProvider = passportNumberProvider;
        this.companyFactory = companyFactory;
        this.timeProvider = timeProvider;
        for (PersonProperties.PersonProperty personProperty : personProperties) {
            personProperty.apply(this, baseProducer);
        }
    }

    @Override
    public Person get() {
        this.generateSex();
        this.generateCompany();
        this.generateFirstName();
        this.generateMiddleName();
        this.generateLastName();
        this.generateEmail();
        this.generateUsername();
        this.generateTelephoneNumber();
        this.generateAge();
        this.generateDateOfBirth();
        this.generateCompanyEmail();
        this.generatePassword();
        this.generateNationalIdentityCardNumber();
        this.generateNationalIdentificationNumber();
        this.generatePassportNumber();
        this.generateAddress();
        this.generateNationality();
        return new Person(this.firstName, this.middleName, this.lastName, this.address, this.email, this.username, this.password, this.sex, this.telephoneNumber, this.dateOfBirth, this.age, this.nationalIdentityCardNumber, this.nationalIdentificationNumber, this.passportNumber, this.company, this.companyEmail, this.nationality);
    }

    @Override
    public void generateSex() {
        if (this.sex != null) {
            return;
        }
        this.sex = this.baseProducer.trueOrFalse() ? Person.Sex.MALE : Person.Sex.FEMALE;
    }

    @Override
    public void generateCompany() {
        if (this.company != null) {
            return;
        }
        this.company = this.companyFactory.produceCompany(new CompanyProperties.CompanyProperty[0]).get();
    }

    @Override
    public void generateFirstName() {
        if (this.firstName != null) {
            return;
        }
        this.firstName = this.dataMaster.getValuesOfType("firstNames", this.sex.name(), String.class);
    }

    @Override
    public void generateMiddleName() {
        if (this.middleName != null) {
            return;
        }
        this.middleName = this.baseProducer.trueOrFalse() ? this.dataMaster.getValuesOfType("firstNames", this.sex.name(), String.class) : "";
    }

    @Override
    public void generateLastName() {
        if (this.lastName != null) {
            return;
        }
        this.lastName = this.dataMaster.getValuesOfType("lastNames", this.sex.name(), String.class);
    }

    @Override
    public void generateEmail() {
        if (this.email != null) {
            return;
        }
        EmailProvider emailProvider = new EmailProvider(this.dataMaster, this.baseProducer, this.firstName, this.lastName);
        this.email = emailProvider.get();
    }

    @Override
    public void generateUsername() {
        if (this.username != null) {
            return;
        }
        this.username = this.baseProducer.trueOrFalse() ? StringUtils.lowerCase((String)StringUtils.stripAccents((String)(this.firstName.substring(0, 1) + this.lastName))) : StringUtils.lowerCase((String)StringUtils.stripAccents((String)(this.firstName + this.lastName.substring(0, 1))));
    }

    @Override
    public void generateTelephoneNumber() {
        if (this.telephoneNumber != null) {
            return;
        }
        if (this.telephoneNumberFormat == null) {
            this.telephoneNumberFormat = this.dataMaster.getRandomValue("telephone_number_formats");
        }
        this.telephoneNumber = this.baseProducer.numerify(this.telephoneNumberFormat);
    }

    @Override
    public void generateAge() {
        if (this.dateOfBirth != null) {
            this.age = (int)ChronoUnit.YEARS.between(this.dateOfBirth, LocalDateTime.now());
        } else {
            if (this.age != null) {
                return;
            }
            this.age = this.baseProducer.randomBetween(1, 100);
        }
    }

    @Override
    public void generateDateOfBirth() {
        if (this.dateOfBirth != null) {
            return;
        }
        LocalDate maxDate = this.timeProvider.getCurrentDate().minusYears(this.age.intValue());
        LocalDate minDate = maxDate.minusYears(1L).plusDays(1L);
        this.dateOfBirth = this.dateProducer.randomDateBetweenTwoDates(minDate, maxDate);
    }

    @Override
    public void generateCompanyEmail() {
        if (this.companyEmail != null) {
            return;
        }
        CompanyEmailProvider companyEmailProvider = new CompanyEmailProvider(this.firstName, this.lastName, this.company);
        this.companyEmail = companyEmailProvider.get();
    }

    @Override
    public void generatePassword() {
        if (this.password != null) {
            return;
        }
        this.password = RandomStringUtils.randomAlphanumeric((int)8);
    }

    @Override
    public void generateNationalIdentityCardNumber() {
        if (this.nationalIdentityCardNumber != null) {
            return;
        }
        this.nationalIdentityCardNumber = this.nationalIdentityCardNumberProvider.get();
    }

    @Override
    public void generateNationalIdentificationNumber() {
        if (this.nationalIdentificationNumber != null) {
            return;
        }
        this.nationalIdentificationNumber = this.nationalIdentificationNumberFactory.produceNationalIdentificationNumberProvider(NationalIdentificationNumberProperties.dateOfBirth(this.dateOfBirth), NationalIdentificationNumberProperties.sex(this.sex)).get().getValue();
    }

    @Override
    public void generateAddress() {
        if (this.address != null) {
            return;
        }
        this.address = this.addressProvider.get();
    }

    @Override
    public void generatePassportNumber() {
        if (this.passportNumber != null) {
            return;
        }
        this.passportNumber = this.passportNumberProvider.get();
    }

    private void generateNationality() {
        List<Country> countries = Country.findCountryForLanguage(this.dataMaster.getLanguage());
        this.nationality = !countries.isEmpty() ? this.baseProducer.randomElement(countries) : Country.UnitedKingdom;
    }

    @Override
    public void setTelephoneNumberFormat(String telephoneFormat) {
        this.telephoneNumberFormat = telephoneFormat;
    }

    @Override
    public void setSex(Person.Sex sex) {
        this.sex = sex;
    }

    @Override
    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public void setCompany(Company company) {
        this.company = company;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @Override
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public void setCompanyEmail(String companyEmail) {
        this.companyEmail = companyEmail;
    }

    @Override
    public void setNationalIdentityCardNumber(String nationalIdentityCardNumber) {
        this.nationalIdentityCardNumber = nationalIdentityCardNumber;
    }

    @Override
    public void setNationalIdentificationNumber(String nationalIdentificationNumber) {
        this.nationalIdentificationNumber = nationalIdentificationNumber;
    }

    @Override
    public void setPassportNumber(String passportNumber) {
        this.passportNumber = passportNumber;
    }
}

