/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.person;

import com.devskiller.jfairy.producer.util.LanguageCode;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum Country {
    Poland("PL", LanguageCode.PL),
    UnitedKingdom("GB", LanguageCode.EN),
    Australia("AU", LanguageCode.EN),
    USA("US", LanguageCode.EN),
    Canada("CA", LanguageCode.EN, LanguageCode.FR),
    Spain("ES", LanguageCode.ES),
    France("FR", LanguageCode.FR),
    Georgia("GE", LanguageCode.KA),
    Italy("IT", LanguageCode.IT),
    Germany("DE", LanguageCode.DE),
    Sweden("SE", LanguageCode.SV),
    China("CN", LanguageCode.ZH);

    private final String code;
    private final List<LanguageCode> languages;

    private Country(String code, LanguageCode ... language) {
        this.code = code;
        this.languages = Arrays.asList(language);
    }

    public String getCode() {
        return this.code;
    }

    public static List<Country> findCountryForLanguage(LanguageCode language) {
        return Arrays.stream(Country.values()).filter(country -> country.languages.contains((Object)language)).collect(Collectors.toList());
    }
}

