/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.payment;

import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.payment.IBAN;
import com.devskiller.jfairy.producer.payment.IBANProperties;
import com.devskiller.jfairy.producer.payment.IBANProvider;
import com.devskiller.jfairy.producer.person.Country;
import com.google.common.base.Strings;
import java.util.IllegalFormatCodePointException;
import java.util.List;
import javax.inject.Inject;
import org.iban4j.CountryCode;
import org.iban4j.Iban;
import org.iban4j.UnsupportedCountryException;

public class DefaultIBANProvider
implements IBANProvider {
    protected DataMaster dataMaster;
    protected BaseProducer baseProducer;
    protected CountryCode countryCode;
    protected String accountNumber;
    protected String bankCode;
    protected String branchCode;
    protected String nationalCheckDigit;

    @Inject
    public DefaultIBANProvider(BaseProducer baseProducer, DataMaster dataMaster, IBANProperties.Property ... properties) {
        this.dataMaster = dataMaster;
        this.baseProducer = baseProducer;
        for (IBANProperties.Property property : properties) {
            property.apply(this);
        }
    }

    @Override
    public IBAN get() {
        try {
            this.fillCountryCode();
            try {
                Iban.Builder builder = new Iban.Builder().countryCode(this.countryCode).bankCode(this.bankCode).branchCode(this.branchCode).nationalCheckDigit(this.nationalCheckDigit);
                if (!Strings.isNullOrEmpty((String)this.accountNumber)) {
                    builder.accountNumber(this.accountNumber);
                }
                Iban iban = builder.buildRandom();
                String identificationNumber = iban.getIdentificationNumber();
                String checkDigit = iban.getCheckDigit();
                String accountType = iban.getAccountType();
                String bban = iban.getBban();
                String ownerAccountType = iban.getOwnerAccountType();
                String ibanNumber = iban.toString();
                return new IBAN(this.accountNumber, identificationNumber, this.branchCode, checkDigit, accountType, this.bankCode, bban, this.countryCode.getName(), this.nationalCheckDigit, ownerAccountType, ibanNumber);
            }
            catch (UnsupportedCountryException e) {
                return null;
            }
        }
        catch (IllegalFormatCodePointException e) {
            throw new IllegalArgumentException("Invalid iban " + e.getMessage(), e);
        }
    }

    @Override
    public void fillCountryCode() {
        if (this.countryCode == null) {
            List<Country> countries = Country.findCountryForLanguage(this.dataMaster.getLanguage());
            Country country = this.baseProducer.randomElement(countries);
            this.countryCode = CountryCode.valueOf((String)country.getCode());
        }
    }

    @Override
    public void setNationalCheckDigit(String nationalCheckDigit) {
        this.nationalCheckDigit = nationalCheckDigit;
    }

    @Override
    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    @Override
    public void setCountry(String country) {
        this.countryCode = CountryCode.valueOf((String)country);
    }

    @Override
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @Override
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
}

