/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy.producer.company.locale.sv;

import com.devskiller.jfairy.producer.BaseProducer;
import com.devskiller.jfairy.producer.DateProducer;
import com.devskiller.jfairy.producer.VATIdentificationNumberProvider;
import com.devskiller.jfairy.producer.person.NationalIdentificationNumberFactory;
import com.devskiller.jfairy.producer.person.NationalIdentificationNumberProperties;
import com.devskiller.jfairy.producer.person.NationalIdentificationNumberProvider;
import com.devskiller.jfairy.producer.person.locale.sv.SvNationalIdentificationNumberProvider;
import java.time.LocalDate;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class SvVATIdentificationNumberProvider
implements VATIdentificationNumberProvider {
    private static final int VAT_IDENTIFICATION_NUMBER_LENGTH = 14;
    private static final int SOLE_TRADER_UPPER_AGE_LIMIT = 16;
    private static final int SOLE_TRADER_LOWER_AGE_LIMIT = 100;
    private static final String SE = "SE";
    private final BaseProducer baseProducer;
    private final DateProducer dateProducer;
    private final NationalIdentificationNumberFactory nationalIdentificationNumberFactory;

    @Inject
    public SvVATIdentificationNumberProvider(BaseProducer baseProducer, DateProducer dateProducer, NationalIdentificationNumberFactory nationalIdentificationNumberFactory) {
        this.baseProducer = baseProducer;
        this.dateProducer = dateProducer;
        this.nationalIdentificationNumberFactory = nationalIdentificationNumberFactory;
    }

    @Override
    public String get() {
        boolean isSoleTrader = this.baseProducer.trueOrFalse();
        if (isSoleTrader) {
            return this.generateVatNumberForSoleTrader();
        }
        int randomGroupNumber = this.baseProducer.randomElement(GroupNumber.class).getValue();
        String randomNumericBetween20And99 = StringUtils.leftPad((String)String.valueOf(this.baseProducer.randomBetween(20, 99)), (int)2, (String)"0");
        String organizationNumberWithoutChecksum = randomGroupNumber + RandomStringUtils.randomNumeric((int)1) + randomNumericBetween20And99 + RandomStringUtils.randomNumeric((int)5);
        String organizationNumber = organizationNumberWithoutChecksum + SvNationalIdentificationNumberProvider.calculateChecksum(organizationNumberWithoutChecksum);
        return SE + organizationNumber + "01";
    }

    private String generateVatNumberForSoleTrader() {
        LocalDate lowerAgeLimit = LocalDate.now().minusYears(100L);
        LocalDate upperAgeLimit = LocalDate.now().minusYears(16L);
        LocalDate dateOfBirth = this.dateProducer.randomDateBetweenTwoDates(lowerAgeLimit, upperAgeLimit);
        NationalIdentificationNumberProvider nationalIdentificationNumberProvider = this.nationalIdentificationNumberFactory.produceNationalIdentificationNumberProvider(NationalIdentificationNumberProperties.dateOfBirth(dateOfBirth));
        String personalIdentityNumber = nationalIdentificationNumberProvider.get().getValue();
        return SE + personalIdentityNumber.replace("-", "") + "01";
    }

    public static boolean isValid(String vatIdentificationNumber) {
        int length = vatIdentificationNumber.length();
        if (length != 14) {
            return false;
        }
        int checksum = Integer.valueOf(Character.toString(vatIdentificationNumber.charAt(length - 3)));
        int checkDigit = SvNationalIdentificationNumberProvider.calculateChecksum(vatIdentificationNumber.substring(2, vatIdentificationNumber.length() - 2));
        return checkDigit == checksum;
    }

    private static enum GroupNumber {
        ESTATE(1),
        STATE_OR_COUNTY_OR_MUNICIPALITY_OR_PARISH(2),
        FOREIGN_COMPANY(3),
        LIMITED_COMPANY(5),
        PARTNERSHIP(6),
        ECONOMIC_ASSOCIATION(7),
        NON_PROFIT_ASSOCIATION_OR_FOUNDATION(8),
        TRADING_COMPANY_OR_LIMITED_COMPANY_OR_PARTNERSHIP(9);

        private final int value;

        private GroupNumber(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

