/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.jfairy;

import com.devskiller.jfairy.DeFairyModule;
import com.devskiller.jfairy.EnFairyModule;
import com.devskiller.jfairy.EsFairyModule;
import com.devskiller.jfairy.Fairy;
import com.devskiller.jfairy.FairyFactory;
import com.devskiller.jfairy.FairyModule;
import com.devskiller.jfairy.KaFairyModule;
import com.devskiller.jfairy.PlFairyModule;
import com.devskiller.jfairy.SvFairyModule;
import com.devskiller.jfairy.ZhFairyModule;
import com.devskiller.jfairy.data.DataMaster;
import com.devskiller.jfairy.data.DataMasterModule;
import com.devskiller.jfairy.data.MapBasedDataMaster;
import com.devskiller.jfairy.producer.RandomGenerator;
import com.devskiller.jfairy.producer.util.LanguageCode;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(Bootstrap.class);
    private static final String DATA_FILE_PREFIX = "jfairy";

    public static Fairy createFairy(DataMaster dataMaster, Locale locale, RandomGenerator randomGenerator) {
        FairyModule fairyModule = Bootstrap.getFairyModuleForLocale(dataMaster, locale, randomGenerator);
        Injector injector = Guice.createInjector((Module[])new Module[]{fairyModule});
        FairyFactory fairyFactory = (FairyFactory)injector.getInstance(FairyFactory.class);
        return fairyFactory.createFairy();
    }

    private static void fillDefaultDataMaster(MapBasedDataMaster dataMaster, Locale locale, String filePrefix) {
        try {
            dataMaster.readResources(filePrefix + ".yml");
            dataMaster.readResources(filePrefix + "_" + locale.getLanguage() + ".yml");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Fairy create() {
        return Bootstrap.builder().build();
    }

    public static Fairy create(Locale locale) {
        return Bootstrap.builder().withLocale(locale).build();
    }

    public static Fairy create(Locale locale, String dataFilePrefix) {
        return Bootstrap.builder().withLocale(locale).withFilePrefix(dataFilePrefix).build();
    }

    public static Fairy create(Provider<DataMaster> dataMaster, Locale locale) {
        return Bootstrap.builder().withDataMasterProvider(dataMaster).withLocale(locale).build();
    }

    private static FairyModule getFairyModuleForLocale(DataMaster dataMaster, Locale locale, RandomGenerator randomGenerator) {
        LanguageCode code;
        try {
            code = LanguageCode.valueOf(locale.getLanguage().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Uknown locale " + locale);
            code = LanguageCode.EN;
        }
        switch (code) {
            case PL: {
                return new PlFairyModule(dataMaster, randomGenerator);
            }
            case EN: {
                return new EnFairyModule(dataMaster, randomGenerator);
            }
            case ES: {
                return new EsFairyModule(dataMaster, randomGenerator);
            }
            case FR: {
                return new EsFairyModule(dataMaster, randomGenerator);
            }
            case SV: {
                return new SvFairyModule(dataMaster, randomGenerator);
            }
            case ZH: {
                return new ZhFairyModule(dataMaster, randomGenerator);
            }
            case DE: {
                return new DeFairyModule(dataMaster, randomGenerator);
            }
            case KA: {
                return new KaFairyModule(dataMaster, randomGenerator);
            }
        }
        LOG.info("No data for your language - using EN");
        return new EnFairyModule(dataMaster, randomGenerator);
    }

    public static class Builder {
        private Locale locale = Locale.ENGLISH;
        private String filePrefix = "jfairy";
        private RandomGenerator randomGenerator = new RandomGenerator();
        private DataMaster dataMaster;

        private MapBasedDataMaster getDefaultDataMaster() {
            Injector injector = Guice.createInjector((Module[])new Module[]{new DataMasterModule(this.randomGenerator)});
            return (MapBasedDataMaster)injector.getInstance(MapBasedDataMaster.class);
        }

        private Builder() {
        }

        public Builder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withFilePrefix(String filePrefix) {
            this.filePrefix = filePrefix;
            return this;
        }

        public Builder withRandomSeed(int randomSeed) {
            this.randomGenerator = new RandomGenerator(randomSeed);
            return this;
        }

        public Builder withDataMasterProvider(Provider<DataMaster> dataMasterProvider) {
            this.dataMaster = (DataMaster)dataMasterProvider.get();
            return this;
        }

        public Fairy build() {
            if (this.dataMaster == null) {
                this.dataMaster = this.getDefaultDataMaster();
                Bootstrap.fillDefaultDataMaster((MapBasedDataMaster)this.dataMaster, this.locale, this.filePrefix);
            }
            return Bootstrap.createFairy(this.dataMaster, this.locale, this.randomGenerator);
        }
    }
}

