/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check;

import com.devonfw.ide.sonarqube.common.api.JavaType;
import com.devonfw.ide.sonarqube.common.api.config.Component;
import com.devonfw.ide.sonarqube.common.api.config.DevonArchitecturePackage;
import com.devonfw.ide.sonarqube.common.api.config.DevonPackage;
import com.devonfw.ide.sonarqube.common.impl.check.DevonArchitectureCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;

public abstract class DevonArchitectureComponentCheck
extends DevonArchitectureCheck {
    @Override
    public void doScanFile(ClassTree tree, JavaFileScannerContext context) {
    }

    protected Component getComponent(String name) {
        return this.getConfiguration().getArchitecture().getComponent(name);
    }

    @Override
    protected String checkDependency(JavaType source, JavaType target) {
        boolean targetDependencyAllowed;
        String targetName;
        DevonArchitecturePackage sourcePkg = source.getDevonPackage();
        DevonArchitecturePackage targetPkg = target.getDevonPackage();
        String sourceComponentName = sourcePkg.getComponent();
        String targetComponentName = targetPkg.getComponent();
        boolean sameRoot = sourcePkg.hasSameRoot(targetPkg);
        if (sourceComponentName.equals(targetComponentName) && sameRoot) {
            return null;
        }
        Component sourceComponent = this.getComponent(sourceComponentName);
        if (sourceComponent == null) {
            return null;
        }
        if (sameRoot) {
            targetName = targetComponentName;
            targetDependencyAllowed = sourceComponent.hasDependency(targetName);
        } else {
            String targetRoot = targetPkg.getRoot();
            String targetRootApp = DevonPackage.composePackage(targetRoot, targetPkg.getApplication());
            targetName = DevonPackage.composePackage(targetRootApp, targetComponentName);
            targetDependencyAllowed = sourceComponent.hasDependency(targetRoot);
            if (!targetDependencyAllowed && !(targetDependencyAllowed = sourceComponent.hasDependency(targetRootApp))) {
                targetDependencyAllowed = sourceComponent.hasDependency(targetName);
            }
        }
        if (!targetDependencyAllowed) {
            return this.targetDependencyNotAllowed(sourceComponent, targetName);
        }
        return this.checkDependency(source, sourceComponent, target);
    }

    protected String targetDependencyNotAllowed(Component sourceComponent, String targetComponentName) {
        return null;
    }

    protected abstract String checkDependency(JavaType var1, Component var2, JavaType var3);
}

