/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.api.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Packages {
    private static final String PATTERN_SEGMENT = "[a-zA-Z0-9_]+";
    private static final String PATTERN_LAYERS = "common|dataaccess|service|batch|logic|client|gui";
    private static final String PATTERN_SCOPES = "api|base|impl";
    private static final String DEFAULT_PATTERN = "([a-zA-Z0-9_]+)\\.(common|dataaccess|service|batch|logic|client|gui)\\.(api|base|impl)(\\.[a-zA-Z0-9_]+)*";
    private static final List<String> DEFAULT_GROUPS = Arrays.asList("component", "layer", "scope", "detail");
    private String pattern;
    private transient Pattern regex;
    private Map<String, String> mappings;
    private List<String> groups;
    private int minimumRootSegments;

    public Packages() {
    }

    public Packages(String pattern, Map<String, String> mappings, List<String> groups) {
        this.pattern = pattern;
        this.mappings = mappings;
        this.groups = groups;
    }

    public static Packages getDefault() {
        HashMap<String, String> defaultMappings = new HashMap<String, String>();
        defaultMappings.put("gui", "client");
        Packages packages = new Packages(DEFAULT_PATTERN, defaultMappings, DEFAULT_GROUPS);
        packages.minimumRootSegments = 3;
        return packages;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.regex = null;
        this.pattern = pattern;
    }

    public Pattern patternRegex() {
        if (this.regex == null && this.pattern != null) {
            this.regex = Pattern.compile(this.pattern);
        }
        return this.regex;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public int getMinimumRootSegments() {
        return this.minimumRootSegments;
    }

    public void setMinimumRootSegments(int minimumRootSegments) {
        this.minimumRootSegments = minimumRootSegments;
    }
}

