/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.nls.base.AbstractNlsMessage;
import net.sf.mmm.util.nls.base.NlsBundleHelper;
import net.sf.mmm.util.nls.impl.NlsResourceBundleLocator;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;
import net.sf.mmm.util.resource.api.DataResource;
import org.slf4j.Logger;

public class NlsResourceBundleLocatorImpl
extends AbstractLoggableComponent
implements NlsResourceBundleLocator {
    private List<ResourceBundle> nlsBundles;
    private ReflectionUtil reflectionUtil;

    protected List<ResourceBundle> getNlsBundles() {
        return this.nlsBundles;
    }

    public void setNlsBundles(List<ResourceBundle> nlsBundles) {
        this.getInitializationState().requireNotInitilized();
        this.nlsBundles = nlsBundles;
    }

    public ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.reflectionUtil = reflectionUtil;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.reflectionUtil == null) {
            this.reflectionUtil = ReflectionUtilImpl.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceBundle> findBundles() {
        if (this.nlsBundles == null) {
            NlsResourceBundleLocatorImpl nlsResourceBundleLocatorImpl = this;
            synchronized (nlsResourceBundleLocatorImpl) {
                if (this.nlsBundles == null && this.nlsBundles == null) {
                    this.nlsBundles = Collections.unmodifiableList(this.loadNlsBundles());
                }
            }
        }
        return this.nlsBundles;
    }

    private List<ResourceBundle> loadNlsBundles() {
        Logger logger = this.getLogger();
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        Set<DataResource> bundleResources = this.reflectionUtil.findResources("META-INF/net.sf.mmm/nls-bundles");
        for (DataResource dataResource : bundleResources) {
            if (logger.isTraceEnabled()) {
                logger.trace("Loading " + dataResource.getUri());
            }
            try {
                InputStream inStream = dataResource.openStream();
                Throwable throwable = null;
                try {
                    InputStreamReader isr = new InputStreamReader(inStream);
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(isr);
                        Throwable throwable3 = null;
                        try {
                            boolean noEntryInBundleResource = true;
                            String line = reader.readLine();
                            while (line != null) {
                                ResourceBundle bundleInstance;
                                if ((line = line.trim()).length() > 0 && (bundleInstance = this.loadNlsBundle(logger, dataResource, line)) != null) {
                                    bundles.add(bundleInstance);
                                    noEntryInBundleResource = false;
                                }
                                line = reader.readLine();
                            }
                            if (!noEntryInBundleResource) continue;
                            logger.error("Illegal bundle declaration " + dataResource.getUri() + ": no entry!");
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (isr == null) continue;
                        if (throwable2 != null) {
                            try {
                                isr.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        isr.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (inStream == null) continue;
                    if (throwable != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    inStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeIoException((Throwable)e, IoMode.READ);
            }
        }
        return bundles;
    }

    private ResourceBundle loadNlsBundle(Logger logger, DataResource dataResource, String line) {
        if (logger.isTraceEnabled()) {
            logger.trace("Loading resource bundle " + line);
        }
        try {
            ResourceBundle bundleInstance = NlsBundleHelper.getInstance().getResourceBundle(line, AbstractNlsMessage.LOCALE_ROOT);
            return bundleInstance;
        }
        catch (Exception e) {
            logger.error("Illegal bundle declaration " + dataResource.getUri() + ": Class '" + line + "' is invalid!", (Throwable)e);
            return null;
        }
    }
}

