/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import net.sf.mmm.util.collection.api.DoubleLinkedNode;
import net.sf.mmm.util.collection.base.AbstractLinkedNode;

public class BasicDoubleLinkedNode<V>
extends AbstractLinkedNode<V, BasicDoubleLinkedNode<V>>
implements DoubleLinkedNode<V, BasicDoubleLinkedNode<V>> {
    private BasicDoubleLinkedNode<V> previous;

    @Override
    public BasicDoubleLinkedNode<V> getPrevious() {
        return this.previous;
    }

    public void setPrevious(BasicDoubleLinkedNode<V> previous) {
        this.previous = previous;
    }

    public BasicDoubleLinkedNode<V> insertAsNext(V value, boolean overrideNullValue) {
        if (overrideNullValue && this.getValue() == null) {
            this.setValue(value);
            return this;
        }
        BasicDoubleLinkedNode<V> node = new BasicDoubleLinkedNode<V>();
        node.setValue(value);
        node.previous = this;
        this.setNext(node);
        return node;
    }

    public void insertAsNext(BasicDoubleLinkedNode<V> node) {
        BasicDoubleLinkedNode next = (BasicDoubleLinkedNode)this.getNext();
        if (next != null) {
            next.previous = node;
            node.setNext(next);
        }
        node.previous = this;
        this.setNext(node);
    }

    public void insertAsPrevious(BasicDoubleLinkedNode<V> node) {
        if (this.previous != null) {
            this.previous.setNext(node);
            node.previous = this.previous;
        }
        node.setNext(this);
        this.previous = node;
    }

    public BasicDoubleLinkedNode<V> insertAsPrevious(V value, boolean overrideNullValue) {
        if (overrideNullValue && this.getValue() == null) {
            this.setValue(value);
            return this;
        }
        BasicDoubleLinkedNode<V> node = new BasicDoubleLinkedNode<V>();
        node.setValue(value);
        node.setNext(this);
        this.previous = node;
        return node;
    }

    public void remove() {
        BasicDoubleLinkedNode next = (BasicDoubleLinkedNode)this.getNext();
        if (next != null) {
            next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.setNext(next);
        }
    }

    @Override
    public boolean isLinked() {
        if (this.previous != null) {
            return true;
        }
        return super.isLinked();
    }
}

