/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.util;

import com.devonfw.cobigen.api.constants.ConfigurationConstants;
import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobiGenPaths {
    private static final Logger LOG = LoggerFactory.getLogger(CobiGenPaths.class);

    public static Path getCobiGenHomePath() {
        Path cobiGenPath;
        String envValue = System.getenv("COBIGEN_HOME");
        if (!StringUtils.isEmpty((CharSequence)envValue)) {
            LOG.info("Custom configuration folder configured in environment variable {}={}", (Object)"COBIGEN_HOME", (Object)envValue);
            cobiGenPath = Paths.get(envValue, new String[0]);
        } else {
            cobiGenPath = ConfigurationConstants.DEFAULT_HOME;
        }
        if (Files.exists(cobiGenPath, new LinkOption[0])) {
            return cobiGenPath;
        }
        try {
            Files.createDirectories(cobiGenPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CobiGenRuntimeException("Unable to create cobigen home directory at " + cobiGenPath);
        }
        return cobiGenPath;
    }

    public static Path getTemplatesFolderPath() {
        return CobiGenPaths.getTemplatesFolderPath(CobiGenPaths.getCobiGenHomePath());
    }

    public static Path getTemplatesFolderPath(Path home) {
        Path templatesPath = home.resolve("templates");
        if (Files.exists(templatesPath, new LinkOption[0])) {
            return templatesPath;
        }
        try {
            Files.createDirectories(templatesPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CobiGenRuntimeException("Unable to create path " + templatesPath);
        }
        return templatesPath;
    }

    public static Path getExternalProcessesPath(String processPath) {
        Path home = CobiGenPaths.getCobiGenHomePath();
        Path externalServersPath = home.resolve(processPath);
        if (Files.exists(externalServersPath, new LinkOption[0])) {
            return externalServersPath;
        }
        if (new File(externalServersPath.toUri()).mkdir()) {
            return externalServersPath;
        }
        return null;
    }
}

