/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class ObjectToObject
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return true;
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "mapping object to object");
        }
        String mapNewObject = destination.assignIfPossible(String.format("(%s)%s", destination.typeName(), code.callMapper(source, destination.type()), source), new Object[0]);
        String mapExistingObject = code.callMapper(source, destination);
        if (destination.isAssignable()) {
            mapExistingObject = destination.assignIfPossible(String.format("(%s)%s", destination.typeName(), mapExistingObject), new Object[0]);
        }
        String mapStmt = String.format(" %s { %s; } else { %s; }", destination.ifNull(), mapNewObject, mapExistingObject);
        String ipStmt = "";
        if (fieldMap.getInverse() != null) {
            VariableRef inverse = new VariableRef(fieldMap.getInverse(), destination);
            if (inverse.isCollection()) {
                MultiOccurrenceVariableRef inverseCollection = MultiOccurrenceVariableRef.from(inverse);
                ipStmt = ipStmt + inverse.ifNull() + inverse.assign(inverseCollection.newCollection(), new Object[0]) + ";";
                ipStmt = ipStmt + String.format("%s.add(%s);", inverse, destination.owner());
            } else {
                ipStmt = inverse.isArray() ? ipStmt + "/* TODO Orika source code does not support Arrays */" : ipStmt + SourceCodeContext.statement(inverse.assign(destination.owner(), new Object[0]), new Object[0]);
            }
        }
        String mapNull = destination.isAssignable() && ObjectToObject.shouldMapNulls(fieldMap, code) ? String.format(" else {\n %s { %s; }\n}\n", destination.ifPathNotNull(), destination.assign("null", new Object[0])) : "";
        return SourceCodeContext.statement("%s { %s  %s } %s", source.ifNotNull(), mapStmt, ipStmt, mapNull);
    }
}

