/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class AnyTypeToString
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return String.class.equals((Object)fieldMap.getDestination().getType().getRawType());
    }

    @Override
    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return "(\"\" + " + source + ").equals(" + destination + ")";
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (source.isPrimitive()) {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "converting primitive to String");
            }
            return SourceCodeContext.statement(destination.assign("\"\"+ %s", source), new Object[0]);
        }
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "converting " + source.typeName() + " using toString()");
        }
        if (AnyTypeToString.shouldMapNulls(fieldMap, code)) {
            return SourceCodeContext.statement("if (" + source.notNull() + ") {" + SourceCodeContext.statement(destination.assign("%s.toString()", source), new Object[0]) + "} else {" + SourceCodeContext.statement(destination.assign("null", new Object[0]), new Object[0]) + "}", new Object[0]);
        }
        return SourceCodeContext.statement(source.ifNotNull() + destination.assign("%s.toString()", source), new Object[0]);
    }
}

