/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.constructor;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ma.glasnost.orika.metadata.ConstructorParameter;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class ConstructorParameterResolver {
    private final Paranamer paranamer = new CachingParanamer((Paranamer)new AdaptiveParanamer(new Paranamer[]{new BytecodeReadingParanamer(), new AnnotationParanamer()}));
    private final Map<java.lang.reflect.Type, Map<String, Set<Property>>> constructorPropertiesByType = new ConcurrentHashMap<java.lang.reflect.Type, Map<String, Set<Property>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<Property>> getProperties(java.lang.reflect.Type type) {
        Type resolvedType;
        Map<String, Set<Property>> properties = this.constructorPropertiesByType.get(type);
        if (properties == null && (resolvedType = TypeFactory.valueOf(type)).isConcrete() && !resolvedType.isImmutable()) {
            Type type2 = resolvedType;
            synchronized (type2) {
                ConcurrentHashMap constructors = new ConcurrentHashMap();
                ConcurrentHashMap constructorsByProperty = new ConcurrentHashMap();
                for (Constructor<?> constructor : ((Class)resolvedType.getRawType()).getConstructors()) {
                    String[] names = this.paranamer.lookupParameterNames(constructor, false);
                    java.lang.reflect.Type[] types = constructor.getGenericParameterTypes();
                    ArrayList<ConstructorParameter> constructorArgs = new ArrayList<ConstructorParameter>();
                    for (int i = 0; i < names.length; ++i) {
                        Type propertyType = types[i] instanceof ParameterizedType ? TypeFactory.resolveValueOf((ParameterizedType)types[i], resolvedType) : TypeFactory.resolveValueOf((Class)types[i], resolvedType);
                        ConstructorParameter constructorArg = new ConstructorParameter(names[i], propertyType, null);
                        HashMap associatedConstructors = (HashMap)constructorsByProperty.get(constructorArg);
                        if (associatedConstructors == null) {
                            associatedConstructors = new HashMap();
                            constructorsByProperty.put(constructorArg, associatedConstructors);
                        }
                        associatedConstructors.put(constructor, i);
                        constructorArgs.add(constructorArg);
                    }
                    constructors.put(constructor, constructorArgs);
                }
                properties = new HashMap<String, Set<Property>>();
                for (Map.Entry entry : constructorsByProperty.entrySet()) {
                    String key = ((Property)entry.getKey()).getExpression();
                    Set<Property> propertiesByName = properties.get(key);
                    if (propertiesByName == null) {
                        propertiesByName = new LinkedHashSet<Property>();
                        properties.put(key, propertiesByName);
                    }
                    propertiesByName.add(new ConstructorParameter(((Property)entry.getKey()).getName(), ((Property)entry.getKey()).getType(), (Map)entry.getValue()));
                }
                this.constructorPropertiesByType.put(type, properties);
            }
        }
        return properties;
    }

    public Set<Property> getPossibleConstructorParams(java.lang.reflect.Type type, String name) {
        Map<String, Set<Property>> propertiesByType = this.getProperties(type);
        if (propertiesByType != null) {
            return propertiesByType.get(name);
        }
        return null;
    }
}

