/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.cern.colt.map;

import ma.glasnost.orika.cern.colt.map.PrimeFinder;

public class OpenIntObjectHashMap {
    protected int[] table;
    protected Object[] values;
    protected byte[] state;
    protected int freeEntries;
    protected int distinct;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    private int highWaterMark;
    private static final byte FREE = 0;
    private static final byte FULL = 1;
    private static final byte REMOVED = 2;
    private static final int defaultCapacity = 277;
    private static final double defaultMinLoadFactor = 0.2;
    private static final double defaultMaxLoadFactor = 0.5;

    public OpenIntObjectHashMap() {
        this(277);
    }

    public OpenIntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenIntObjectHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public boolean containsKey(int key) {
        return this.indexOfKey(key) >= 0;
    }

    public Object get(int key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(int key) {
        int[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && tab[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 2) {
            int j = i;
            while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (stat[i] == 0) {
                i = j;
            }
        }
        if (stat[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(int key) {
        int[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 0) {
            return -1;
        }
        return i;
    }

    public void clear() {
        this.setUp(this.highWaterMark, this.minLoadFactor, this.maxLoadFactor);
    }

    protected int chooseGrowCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * size) / (3.0 * minLoad + maxLoad))));
    }

    protected int nextPrime(int desiredCapacity) {
        return PrimeFinder.nextPrime(desiredCapacity);
    }

    protected int chooseHighWaterMark(int capacity, double maxLoad) {
        return Math.min(capacity - 2, (int)((double)capacity * maxLoad));
    }

    public boolean put(int key, Object value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        int[] oldTable = this.table;
        Object[] oldValues = this.values;
        byte[] oldState = this.state;
        int[] newTable = new int[newCapacity];
        Object[] newValues = new Object[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            int element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newValues[index] = oldValues[i];
            newState[index] = 1;
        }
    }

    protected int chooseShrinkCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * size) / (minLoad + 3.0 * maxLoad))));
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + initialCapacity);
        }
        if (minLoadFactor < 0.0 || minLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor);
        }
        if (maxLoadFactor <= 0.0 || maxLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + maxLoadFactor);
        }
        if (minLoadFactor >= maxLoadFactor) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor + " and maxLoadFactor: " + maxLoadFactor);
        }
        if ((capacity = this.nextPrime(capacity)) == 0) {
            capacity = 1;
        }
        this.table = new int[capacity];
        this.values = new Object[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }
}

