/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika;

import java.lang.reflect.ParameterizedType;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.util.ClassHelper;

public abstract class CustomConverter<S, D>
implements Converter<S, D> {
    protected Type<S> sourceType;
    protected Type<D> destinationType;
    protected MapperFacade mapperFacade;

    public CustomConverter() {
        java.lang.reflect.Type genericSuperclass = this.getClass().getGenericSuperclass();
        while (genericSuperclass instanceof Class) {
            genericSuperclass = ((Class)genericSuperclass).getGenericSuperclass();
        }
        if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
            ParameterizedType superType = (ParameterizedType)genericSuperclass;
            java.lang.reflect.Type[] actualTypeArguments = superType.getActualTypeArguments();
            if (actualTypeArguments.length == 2) {
                this.sourceType = TypeFactory.valueOf(superType.getActualTypeArguments()[0]);
                this.destinationType = TypeFactory.valueOf(superType.getActualTypeArguments()[1]);
            } else {
                this.sourceType = TypeFactory.valueOf(ClassHelper.findParameterClass(0, this.getClass(), CustomConverter.class));
                this.destinationType = TypeFactory.valueOf(ClassHelper.findParameterClass(1, this.getClass(), CustomConverter.class));
            }
        } else {
            throw new IllegalStateException("When you subclass CustomConverter S and D type-parameters are required.");
        }
        if (this.sourceType == null || this.destinationType == null) {
            throw new IllegalStateException("When you subclass CustomConverter S and D type-parameters are required.");
        }
    }

    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        return this.sourceType.equals(sourceType) && destinationType.equals(this.destinationType);
    }

    @Override
    public void setMapperFacade(MapperFacade mapper) {
        this.mapperFacade = mapper;
    }

    public String toString() {
        String subClass = this.getClass().equals(CustomConverter.class) || this.getClass().isAnonymousClass() ? "" : "(" + this.getClass().getSimpleName() + ")";
        String srcName = TypeFactory.nameOf(this.sourceType, this.destinationType);
        String dstName = TypeFactory.nameOf(this.destinationType, this.sourceType);
        return CustomConverter.class.getSimpleName() + subClass + "<" + srcName + ", " + dstName + ">";
    }

    @Override
    public Type<S> getAType() {
        return this.sourceType;
    }

    @Override
    public Type<D> getBType() {
        return this.destinationType;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

