/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.util.Collection;
import java.util.Iterator;
import net.sf.mmm.util.lang.api.AbstractEqualsChecker;
import net.sf.mmm.util.lang.api.EqualsChecker;

public class EqualsCheckerCollection
extends AbstractEqualsChecker<Object> {
    private static final long serialVersionUID = 1L;
    private final EqualsChecker<Object> delegate;

    public EqualsCheckerCollection(EqualsChecker<Object> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected boolean isEqualNotNull(Object value1, Object value2) {
        if (value1 instanceof Collection) {
            if (!(value2 instanceof Collection)) {
                return false;
            }
            Collection collection1 = (Collection)value1;
            Collection collection2 = (Collection)value2;
            if (!this.isEqualCollectionType(collection1, collection2)) {
                return false;
            }
            int size = collection1.size();
            if (collection2.size() != size) {
                return false;
            }
            Iterator iterator1 = collection1.iterator();
            Iterator iterator2 = collection2.iterator();
            while (iterator1.hasNext()) {
                Object e2;
                Object e1 = iterator1.next();
                if (this.isEqual(e1, e2 = iterator2.next())) continue;
                return false;
            }
            assert (!iterator2.hasNext());
            return true;
        }
        return this.delegate.isEqual(value1, value2);
    }

    protected boolean isEqualCollectionType(Collection<?> collection1, Collection<?> collection2) {
        return collection1.getClass().equals(collection2.getClass());
    }
}

