/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.util.collection.api.CollectionFactory;
import net.sf.mmm.util.collection.api.CollectionFactoryManager;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.ArrayListFactory;
import net.sf.mmm.util.collection.base.ConcurrentHashMapFactory;
import net.sf.mmm.util.collection.base.ConcurrentSkipListMapFactory;
import net.sf.mmm.util.collection.base.HashMapFactory;
import net.sf.mmm.util.collection.base.HashSetFactory;
import net.sf.mmm.util.collection.base.LinkedBlockingQueueFactory;
import net.sf.mmm.util.collection.base.LinkedListDequeFactory;
import net.sf.mmm.util.collection.base.LinkedListQueueFactory;
import net.sf.mmm.util.collection.base.NavigableTreeMapFactory;
import net.sf.mmm.util.collection.base.NavigableTreeSetFactory;
import net.sf.mmm.util.collection.base.TreeSetFactory;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;

public class CollectionFactoryManagerImpl
extends AbstractLoggableComponent
implements CollectionFactoryManager {
    private static CollectionFactoryManager instance;
    private final Map<Class<? extends Collection>, CollectionFactory> collectionFactoryMap;
    private final Map<Class<? extends Map>, MapFactory> mapFactoryMap = new HashMap<Class<? extends Map>, MapFactory>();

    public CollectionFactoryManagerImpl() {
        this.collectionFactoryMap = new HashMap<Class<? extends Collection>, CollectionFactory>();
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        this.registerCollectionFactory(ArrayListFactory.INSTANCE, Collection.class);
        this.registerCollectionFactory(ArrayListFactory.INSTANCE);
        this.registerCollectionFactory(HashSetFactory.INSTANCE);
        this.registerCollectionFactory(TreeSetFactory.INSTANCE);
        this.registerCollectionFactory(LinkedListQueueFactory.INSTANCE);
        this.registerCollectionFactory(LinkedBlockingQueueFactory.INSTANCE);
        this.registerCollectionFactory(LinkedListDequeFactory.INSTANCE);
        this.registerCollectionFactory(NavigableTreeSetFactory.INSTANCE);
        this.registerMapFactory(HashMapFactory.INSTANCE);
        this.registerMapFactory(ConcurrentHashMapFactory.INSTANCE);
        this.registerMapFactory(NavigableTreeMapFactory.INSTANCE);
        this.registerMapFactory(ConcurrentSkipListMapFactory.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectionFactoryManager getInstance() {
        if (instance != null) return instance;
        Class<CollectionFactoryManagerImpl> clazz = CollectionFactoryManagerImpl.class;
        synchronized (CollectionFactoryManagerImpl.class) {
            if (instance != null) return instance;
            CollectionFactoryManagerImpl manager = new CollectionFactoryManagerImpl();
            manager.initialize();
            instance = manager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <C extends Collection> CollectionFactory<C> getCollectionFactory(Class<C> collectionType) {
        return this.collectionFactoryMap.get(collectionType);
    }

    @Override
    public <MAP extends Map> MapFactory getMapFactory(Class<MAP> mapType) {
        return this.mapFactoryMap.get(mapType);
    }

    protected MapFactory registerMapFactory(MapFactory factory) {
        return this.registerMapFactory(factory, factory.getMapInterface());
    }

    protected <MAP extends Map> MapFactory registerMapFactory(MapFactory<? extends MAP> factory, Class<MAP> mapInterface) {
        return this.mapFactoryMap.put(mapInterface, factory);
    }

    protected CollectionFactory registerCollectionFactory(CollectionFactory factory) {
        return this.registerCollectionFactory(factory, factory.getCollectionInterface());
    }

    protected <COLLECTION extends Collection> CollectionFactory registerCollectionFactory(CollectionFactory<? extends COLLECTION> factory, Class<COLLECTION> collectionInterface) {
        if (!collectionInterface.isAssignableFrom(factory.getCollectionInterface())) {
            throw new IllegalArgumentException();
        }
        return this.collectionFactoryMap.put(collectionInterface, factory);
    }
}

