/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Objects;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourceNotAvailableException;
import net.sf.mmm.util.resource.api.ResourceNotWritableException;

public abstract class AbstractDataResource
implements DataResource {
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDataResource other = (AbstractDataResource)obj;
        if (!Objects.equals(this.getPath(), other.getPath())) {
            return false;
        }
        return Objects.equals(this.getSchemePrefix(), other.getSchemePrefix());
    }

    public int hashCode() {
        return Objects.hash(this.getSchemePrefix(), this.getPath());
    }

    public abstract String getSchemePrefix();

    @Override
    public long getSize() throws ResourceNotAvailableException {
        try {
            return this.getUrl().openConnection().getContentLength();
        }
        catch (IOException e) {
            throw new ResourceNotAvailableException((Throwable)e, this.getPath());
        }
    }

    @Override
    public InputStream openStream() {
        try {
            return this.getUrl().openStream();
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    @Override
    public String getPath() {
        return this.getUrl().getPath();
    }

    @Override
    public String getUri() {
        return this.getUrl().toString();
    }

    @Override
    public boolean isAvailable() {
        return this.isData();
    }

    @Override
    public Boolean isModifiedSince(Date date) {
        Date lastModified = this.getLastModificationDate();
        if (lastModified != null) {
            return lastModified.after(date);
        }
        return null;
    }

    @Override
    public OutputStream openOutputStream() throws ResourceNotAvailableException, ResourceNotWritableException, RuntimeIoException {
        throw new ResourceNotWritableException(this.getUri());
    }

    @Override
    public String getName() {
        int startIndex;
        String path = this.getPath();
        int length = path.length();
        if (length == 0) {
            return "";
        }
        int endIndex = length - 1;
        char c = path.charAt(endIndex);
        while (c == '/' || c == '\\') {
            if (--endIndex < 0) {
                return "";
            }
            c = path.charAt(endIndex);
        }
        for (startIndex = endIndex; startIndex > 0 && (c = path.charAt(startIndex - 1)) != '/' && c != '\\'; --startIndex) {
        }
        return path.substring(startIndex, endIndex + 1);
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        String path = this.getPath();
        StringBuilder result = new StringBuilder(simpleName.length() + path.length() + 2);
        result.append(simpleName);
        result.append('[');
        result.append(path);
        result.append(']');
        return result.toString();
    }
}

