/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.filter.api;

import net.sf.mmm.util.filter.api.WhitespaceHelper;

public interface CharFilter {
    public static final CharFilter IDENTIFIER_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-' || c == '.';
        }
    };
    public static final CharFilter LATIN_DIGIT_OR_LETTER_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }
    };
    public static final CharFilter LATIN_DIGIT_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return c >= '0' && c <= '9';
        }
    };
    public static final CharFilter ASCII_LETTER_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }
    };
    public static final CharFilter ASCII_LOWER_CASE_LETTER_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return c >= 'a' && c <= 'z';
        }
    };
    public static final CharFilter ASCII_UPPER_CASE_LETTER_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return c >= 'A' && c <= 'Z';
        }
    };
    public static final CharFilter WHITESPACE_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return WhitespaceHelper.isWhitespace(c);
        }
    };
    public static final CharFilter ACCEPT_ALL_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return true;
        }
    };
    public static final CharFilter FILE_SEPARATOR_FILTER = new CharFilter(){

        @Override
        public boolean accept(char c) {
            return c == '/' || c == '\\';
        }
    };

    public boolean accept(char var1);
}

