/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.mapping.strategy;

import java.util.LinkedHashMap;
import java.util.Map;
import ma.glasnost.orika.MappingStrategy;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public abstract class AbstractMappingStrategy
implements MappingStrategy {
    protected final Type<Object> sourceType;
    protected final Type<Object> destinationType;

    public AbstractMappingStrategy(Type<Object> sourceType, Type<Object> destinationType) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
    }

    @Override
    public Type<Object> getAType() {
        return this.sourceType;
    }

    @Override
    public Type<Object> getBType() {
        return this.destinationType;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(this.getClass().getSimpleName());
        String srcName = TypeFactory.nameOf(this.sourceType, this.destinationType);
        String dstName = TypeFactory.nameOf(this.destinationType, this.sourceType);
        out.append("<").append(srcName).append(", ").append(dstName).append(">").append(" {");
        LinkedHashMap<String, Object> members = new LinkedHashMap<String, Object>();
        this.describeMembers(members);
        String separator = "";
        for (Map.Entry<String, Object> member : members.entrySet()) {
            out.append(separator).append(member.getKey()).append(": ").append(member.getValue());
            separator = ", ";
        }
        out.append("}");
        return out.toString();
    }

    protected abstract void describeMembers(Map<String, Object> var1);
}

