/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.converter.builtin.BuiltinBidirectionalConverter;
import ma.glasnost.orika.metadata.Type;

public class DateAndTimeConverters {
    private static java.util.Date toDate(XMLGregorianCalendar source) {
        return source.toGregorianCalendar().getTime();
    }

    private static java.util.Date toDate(Calendar source) {
        return source.getTime();
    }

    private static java.util.Date toDate(Long source) {
        return new java.util.Date(source);
    }

    private static Calendar toCalendar(XMLGregorianCalendar source) {
        return DateAndTimeConverters.toCalendar(source.toGregorianCalendar().getTime());
    }

    private static Calendar toCalendar(java.util.Date source) {
        Calendar c = Calendar.getInstance();
        c.setTime(source);
        return c;
    }

    private static Calendar toCalendar(Long source) {
        return DateAndTimeConverters.toCalendar(new java.util.Date(source));
    }

    private static XMLGregorianCalendar toXMLGregorianCalendar(Calendar source, DatatypeFactory factory) {
        return DateAndTimeConverters.toXMLGregorianCalendar(source.getTime(), factory);
    }

    private static XMLGregorianCalendar toXMLGregorianCalendar(java.util.Date source, DatatypeFactory factory) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(source);
        return factory.newXMLGregorianCalendar(c);
    }

    private static XMLGregorianCalendar toXMLGregorianCalendar(Long source, DatatypeFactory factory) {
        return DateAndTimeConverters.toXMLGregorianCalendar(new java.util.Date(source), factory);
    }

    private static Long toLong(java.util.Date source) {
        return source.getTime();
    }

    private static Long toLong(Calendar source) {
        return DateAndTimeConverters.toLong(source.getTime());
    }

    private static Long toLong(XMLGregorianCalendar source) {
        return DateAndTimeConverters.toLong(source.toGregorianCalendar().getTime());
    }

    public static boolean _polyCanConvert(Type<?> a, Type<?> b, Type<?> c, Type<?> d) {
        return a.isAssignableFrom(c) && !d.getRawType().equals(Object.class) && d.isAssignableFrom(b);
    }

    public static boolean polyCanConvert(Type<?> a, Type<?> b, Type<?> c, Type<?> d) {
        return DateAndTimeConverters._polyCanConvert(a, b, c, d) || DateAndTimeConverters._polyCanConvert(b, a, c, d);
    }

    public static class DateToTimestampConverter
    extends BuiltinBidirectionalConverter<java.util.Date, Timestamp> {
        @Override
        public Timestamp convertTo(java.util.Date source, Type<Timestamp> destinationType, MappingContext context) {
            return new Timestamp(DateAndTimeConverters.toLong(source));
        }

        @Override
        public java.util.Date convertFrom(Timestamp source, Type<java.util.Date> destinationType, MappingContext context) {
            return DateAndTimeConverters.toDate(source.getTime());
        }
    }

    public static class XmlGregorianCalendarToTimestampConverter
    extends BuiltinBidirectionalConverter<XMLGregorianCalendar, Timestamp> {
        private static DatatypeFactory factory;

        public XmlGregorianCalendarToTimestampConverter() {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Timestamp convertTo(XMLGregorianCalendar source, Type<Timestamp> destinationType, MappingContext context) {
            return new Timestamp(DateAndTimeConverters.toLong(source));
        }

        @Override
        public XMLGregorianCalendar convertFrom(Timestamp source, Type<XMLGregorianCalendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source, XmlGregorianCalendarToTimestampConverter.factory);
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return DateAndTimeConverters.polyCanConvert(this.sourceType, this.destinationType, sourceType, destinationType);
        }
    }

    public static class LongToTimestampConverter
    extends BuiltinBidirectionalConverter<Long, Timestamp> {
        @Override
        public Timestamp convertTo(Long source, Type<Timestamp> destinationType, MappingContext context) {
            return new Timestamp(source);
        }

        @Override
        public Long convertFrom(Timestamp source, Type<Long> destinationType, MappingContext context) {
            return source.getTime();
        }
    }

    public static class LongToXmlGregorianCalendarConverter
    extends BuiltinBidirectionalConverter<Long, XMLGregorianCalendar> {
        private static DatatypeFactory factory;

        public LongToXmlGregorianCalendarConverter() {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public XMLGregorianCalendar convertTo(Long source, Type<XMLGregorianCalendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source, LongToXmlGregorianCalendarConverter.factory);
        }

        @Override
        public Long convertFrom(XMLGregorianCalendar source, Type<Long> destinationType, MappingContext context) {
            return DateAndTimeConverters.toLong(source);
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return DateAndTimeConverters.polyCanConvert(this.sourceType, this.destinationType, sourceType, destinationType);
        }
    }

    public static class LongToCalendarConverter
    extends BuiltinBidirectionalConverter<Long, Calendar> {
        @Override
        public Calendar convertTo(Long source, Type<Calendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toCalendar(source);
        }

        @Override
        public Long convertFrom(Calendar source, Type<Long> destinationType, MappingContext context) {
            return DateAndTimeConverters.toLong(source);
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return DateAndTimeConverters.polyCanConvert(this.sourceType, this.destinationType, sourceType, destinationType);
        }
    }

    public static class LongToTimeConverter
    extends BuiltinBidirectionalConverter<Long, Time> {
        @Override
        public Time convertTo(Long source, Type<Time> destinationType, MappingContext context) {
            return new Time(source);
        }

        @Override
        public Long convertFrom(Time source, Type<Long> destinationType, MappingContext context) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    public static class LongToSqlDateConverter
    extends BuiltinBidirectionalConverter<Long, Date> {
        @Override
        public Date convertTo(Long source, Type<Date> destinationType, MappingContext context) {
            return new Date(source);
        }

        @Override
        public Long convertFrom(Date source, Type<Long> destinationType, MappingContext context) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    public static class LongToDateConverter
    extends BuiltinBidirectionalConverter<Long, java.util.Date> {
        @Override
        public java.util.Date convertTo(Long source, Type<java.util.Date> destinationType, MappingContext context) {
            return DateAndTimeConverters.toDate(source);
        }

        @Override
        public Long convertFrom(java.util.Date source, Type<Long> destinationType, MappingContext context) {
            return DateAndTimeConverters.toLong(source);
        }
    }

    public static class CalendarToXmlGregorianCalendarConverter
    extends BuiltinBidirectionalConverter<Calendar, XMLGregorianCalendar> {
        private static DatatypeFactory factory;

        public CalendarToXmlGregorianCalendarConverter() {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public XMLGregorianCalendar convertTo(Calendar source, Type<XMLGregorianCalendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source, CalendarToXmlGregorianCalendarConverter.factory);
        }

        @Override
        public Calendar convertFrom(XMLGregorianCalendar source, Type<Calendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toCalendar(source);
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return DateAndTimeConverters.polyCanConvert(this.sourceType, this.destinationType, sourceType, destinationType);
        }
    }

    public static class DateToXmlGregorianCalendarConverter
    extends BuiltinBidirectionalConverter<java.util.Date, XMLGregorianCalendar> {
        private static DatatypeFactory factory;

        public DateToXmlGregorianCalendarConverter() {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public XMLGregorianCalendar convertTo(java.util.Date source, Type<XMLGregorianCalendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source, DateToXmlGregorianCalendarConverter.factory);
        }

        @Override
        public java.util.Date convertFrom(XMLGregorianCalendar source, Type<java.util.Date> destinationType, MappingContext context) {
            return DateAndTimeConverters.toDate(source);
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return DateAndTimeConverters.polyCanConvert(this.sourceType, this.destinationType, sourceType, destinationType);
        }
    }

    public static class CalendarToTimeConverter
    extends BuiltinBidirectionalConverter<Calendar, Time> {
        @Override
        public Time convertTo(Calendar source, Type<Time> destinationType, MappingContext context) {
            return new Time(DateAndTimeConverters.toLong(source));
        }

        @Override
        public Calendar convertFrom(Time source, Type<Calendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toCalendar(source);
        }
    }

    public static class CalendarToSqlDateConverter
    extends BuiltinBidirectionalConverter<Calendar, Date> {
        @Override
        public Date convertTo(Calendar source, Type<Date> destinationType, MappingContext context) {
            return new Date(DateAndTimeConverters.toLong(source));
        }

        @Override
        public Calendar convertFrom(Date source, Type<Calendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toCalendar(source);
        }
    }

    public static class XmlGregorianCalendarToTimeConverter
    extends BuiltinBidirectionalConverter<XMLGregorianCalendar, Time> {
        private static DatatypeFactory factory;

        public XmlGregorianCalendarToTimeConverter() {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Time convertTo(XMLGregorianCalendar source, Type<Time> destinationType, MappingContext context) {
            return new Time(DateAndTimeConverters.toLong(source));
        }

        @Override
        public XMLGregorianCalendar convertFrom(Time source, Type<XMLGregorianCalendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source.getTime(), XmlGregorianCalendarToTimeConverter.factory);
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return DateAndTimeConverters.polyCanConvert(this.sourceType, this.destinationType, sourceType, destinationType);
        }
    }

    public static class XmlGregorianCalendarToSqlDateConverter
    extends BuiltinBidirectionalConverter<XMLGregorianCalendar, Date> {
        private static DatatypeFactory factory;

        public XmlGregorianCalendarToSqlDateConverter() {
            try {
                factory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Date convertTo(XMLGregorianCalendar source, Type<Date> destinationType, MappingContext context) {
            return new Date(DateAndTimeConverters.toLong(source));
        }

        @Override
        public XMLGregorianCalendar convertFrom(Date source, Type<XMLGregorianCalendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toXMLGregorianCalendar(source.getTime(), XmlGregorianCalendarToSqlDateConverter.factory);
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return DateAndTimeConverters.polyCanConvert(this.sourceType, this.destinationType, sourceType, destinationType);
        }
    }

    public static class DateToTimeConverter
    extends BuiltinBidirectionalConverter<java.util.Date, Time> {
        @Override
        public Time convertTo(java.util.Date source, Type<Time> destinationType, MappingContext context) {
            return new Time(source.getTime());
        }

        @Override
        public java.util.Date convertFrom(Time source, Type<java.util.Date> destinationType, MappingContext context) {
            return new java.util.Date(source.getTime());
        }
    }

    public static class DateToSqlDateConverter
    extends BuiltinBidirectionalConverter<java.util.Date, Date> {
        @Override
        public Date convertTo(java.util.Date source, Type<Date> destinationType, MappingContext context) {
            return new Date(source.getTime());
        }

        @Override
        public java.util.Date convertFrom(Date source, Type<java.util.Date> destinationType, MappingContext context) {
            return new java.util.Date(source.getTime());
        }
    }

    public static class DateToCalendarConverter
    extends BuiltinBidirectionalConverter<java.util.Date, Calendar> {
        @Override
        public Calendar convertTo(java.util.Date source, Type<Calendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toCalendar(source);
        }

        @Override
        public java.util.Date convertFrom(Calendar source, Type<java.util.Date> destinationType, MappingContext context) {
            return DateAndTimeConverters.toDate(source);
        }
    }

    public static class TimestampToSqlDateConverter
    extends BuiltinBidirectionalConverter<Timestamp, Date> {
        @Override
        public Date convertTo(Timestamp source, Type<Date> destinationType, MappingContext context) {
            return new Date(source.getTime());
        }

        @Override
        public Timestamp convertFrom(Date source, Type<Timestamp> destinationType, MappingContext context) {
            return new Timestamp(source.getTime());
        }
    }

    public static class TimestampToTimeConverter
    extends BuiltinBidirectionalConverter<Timestamp, Time> {
        @Override
        public Time convertTo(Timestamp source, Type<Time> destinationType, MappingContext context) {
            return new Time(source.getTime());
        }

        @Override
        public Timestamp convertFrom(Time source, Type<Timestamp> destinationType, MappingContext context) {
            return new Timestamp(source.getTime());
        }
    }

    public static class TimeToSqlDateConverter
    extends BuiltinBidirectionalConverter<Time, Date> {
        @Override
        public Date convertTo(Time source, Type<Date> destinationType, MappingContext context) {
            return new Date(source.getTime());
        }

        @Override
        public Time convertFrom(Date source, Type<Time> destinationType, MappingContext context) {
            return new Time(source.getTime());
        }
    }

    public static class TimestampToCalendarConverter
    extends BuiltinBidirectionalConverter<Timestamp, Calendar> {
        @Override
        public Calendar convertTo(Timestamp source, Type<Calendar> destinationType, MappingContext context) {
            return DateAndTimeConverters.toCalendar(source.getTime());
        }

        @Override
        public Timestamp convertFrom(Calendar source, Type<Timestamp> destinationType, MappingContext context) {
            return new Timestamp(source.getTime().getTime());
        }
    }
}

