/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import java.util.Locale;
import net.sf.mmm.util.lang.api.BasicHelper;

public enum CaseConversion {
    LOWER_CASE,
    UPPER_CASE,
    ORIGINAL_CASE;

    public static final char EXAMPLE_CHAR_FOR_ORIGINAL_CASE = '$';

    public String convert(String string) {
        return this.convert(string, null);
    }

    public String convert(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        switch (this) {
            case LOWER_CASE: {
                return BasicHelper.toLowerCase(string, locale);
            }
            case UPPER_CASE: {
                return BasicHelper.toUpperCase(string, locale);
            }
        }
        return string;
    }

    public char convert(char c) {
        switch (this) {
            case LOWER_CASE: {
                return Character.toLowerCase(c);
            }
            case UPPER_CASE: {
                return Character.toUpperCase(c);
            }
        }
        return c;
    }

    public char asExample(char c) {
        if (this == ORIGINAL_CASE) {
            return '$';
        }
        return this.convert(c);
    }

    public static CaseConversion ofExample(char c, boolean strict) {
        if (Character.isUpperCase(c)) {
            return UPPER_CASE;
        }
        if (Character.isLowerCase(c)) {
            return LOWER_CASE;
        }
        if (strict && c != '$') {
            throw new IllegalArgumentException(Character.toString(c));
        }
        return ORIGINAL_CASE;
    }

    public static boolean isCaseChange(CaseConversion caseConversion) {
        return caseConversion != null && caseConversion != ORIGINAL_CASE;
    }

    public static boolean areIncompatible(CaseConversion case1, CaseConversion case2) {
        return case1 != case2 && CaseConversion.isCaseChange(case1) && CaseConversion.isCaseChange(case2);
    }
}

