/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl.formatter;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.nls.api.NlsFormatterPlugin;
import net.sf.mmm.util.nls.base.AbstractNlsDependencies;
import net.sf.mmm.util.nls.base.MappedNlsFormatterManager;
import net.sf.mmm.util.nls.base.NlsDependencies;
import net.sf.mmm.util.nls.impl.ConfiguredNlsFormatterMap;
import net.sf.mmm.util.nls.impl.formatter.NlsFormatterChoice;
import net.sf.mmm.util.nls.impl.formatter.NlsFormatterDatePattern;
import net.sf.mmm.util.nls.impl.formatter.NlsFormatterNumberPattern;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

@Named
@Singleton
public class NlsFormatterManagerImpl
extends MappedNlsFormatterManager {
    private NlsDependencies nlsDependencies;

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.nlsDependencies == null) {
            this.nlsDependencies = AbstractNlsDependencies.getInstance();
        }
        if (this.getFormatterMap() == null) {
            ConfiguredNlsFormatterMap formatterMap = new ConfiguredNlsFormatterMap();
            formatterMap.initialize();
            this.setFormatterMap(formatterMap);
        }
    }

    @Override
    protected NlsFormatterPlugin<?> getSubFormatter(String formatType, CharSequenceScanner scanner) {
        if ("choice".equals(formatType)) {
            return new NlsFormatterChoice(scanner, this.nlsDependencies);
        }
        return super.getSubFormatter(formatType, scanner);
    }

    @Override
    protected NlsFormatterPlugin<Object> getSubFormatter(String formatType, String subformat) {
        if ("number".equals(formatType)) {
            return new NlsFormatterNumberPattern(subformat);
        }
        if ("date".equals(formatType) || "time".equals(formatType) || "datetime".equals(formatType)) {
            return new NlsFormatterDatePattern(subformat);
        }
        return super.getSubFormatter(formatType, subformat);
    }

    public NlsDependencies getNlsDependencies() {
        return this.nlsDependencies;
    }

    @Inject
    public void setNlsDependencies(NlsDependencies nlsDependencies) {
        this.getInitializationState().requireNotInitilized();
        this.nlsDependencies = nlsDependencies;
    }
}

