/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.descriptor;

import java.util.Date;
import javax.inject.Named;
import net.sf.mmm.util.lang.base.datatype.descriptor.AbstractDatatypeDescriptor;
import net.sf.mmm.util.lang.base.datatype.descriptor.AbstractDatatypeSegmentDescriptor;

@Named
public class DatatypeDescriptorDate
extends AbstractDatatypeDescriptor<Date> {
    public DatatypeDescriptorDate() {
        super(Date.class, new YearSegment(), new MonthSegment(), new DaySegment(), new HourSegment(), new MinuteSegment(), new SecondSegment());
    }

    @Override
    protected Date doCreate(Object ... segments) {
        int year = (Integer)segments[0];
        int month = (Integer)segments[1];
        int day = (Integer)segments[2];
        if (segments.length > 3) {
            int hour = (Integer)segments[3];
            int minute = 0;
            int second = 0;
            if (segments.length > 4) {
                minute = (Integer)segments[4];
                if (segments.length > 5) {
                    second = (Integer)segments[5];
                }
            }
            return new Date(year - 1900, month - 1, day, hour, minute, second);
        }
        return new Date(year - 1900, month - 1, day);
    }

    private static class SecondSegment
    extends AbstractDatatypeSegmentDescriptor<Date, Integer> {
        public SecondSegment() {
            super("second", Integer.class, true);
        }

        @Override
        protected Integer doGetSegment(Date datatype) {
            return datatype.getSeconds();
        }
    }

    private static class MinuteSegment
    extends AbstractDatatypeSegmentDescriptor<Date, Integer> {
        public MinuteSegment() {
            super("minute", Integer.class, true);
        }

        @Override
        protected Integer doGetSegment(Date datatype) {
            return datatype.getMinutes();
        }
    }

    private static class HourSegment
    extends AbstractDatatypeSegmentDescriptor<Date, Integer> {
        public HourSegment() {
            super("hour", Integer.class, true);
        }

        @Override
        protected Integer doGetSegment(Date datatype) {
            return datatype.getHours();
        }
    }

    private static class DaySegment
    extends AbstractDatatypeSegmentDescriptor<Date, Integer> {
        public DaySegment() {
            super("day", Integer.class);
        }

        @Override
        protected Integer doGetSegment(Date datatype) {
            return datatype.getDate();
        }
    }

    private static class MonthSegment
    extends AbstractDatatypeSegmentDescriptor<Date, Integer> {
        public MonthSegment() {
            super("month", Integer.class);
        }

        @Override
        protected Integer doGetSegment(Date datatype) {
            return datatype.getMonth() + 1;
        }
    }

    private static class YearSegment
    extends AbstractDatatypeSegmentDescriptor<Date, Integer> {
        public YearSegment() {
            super("year", Integer.class);
        }

        @Override
        protected Integer doGetSegment(Date datatype) {
            return datatype.getYear() + 1900;
        }
    }
}

