/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.adapter.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import javax.inject.Inject;
import net.sf.mmm.util.lang.api.EnumProvider;

public class EnumTypeJsonDeserializer<T>
extends JsonDeserializer<T> {
    private final Class<T> enumType;
    private EnumProvider enumProvider;

    public EnumTypeJsonDeserializer(Class<T> datatype) {
        this.enumType = datatype;
    }

    public EnumTypeJsonDeserializer(Class<T> datatype, EnumProvider enumProvider) {
        this.enumType = datatype;
        this.enumProvider = enumProvider;
    }

    @Inject
    public void setEnumProvider(EnumProvider enumProvider) {
        this.enumProvider = enumProvider;
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        String value = parser.getText();
        return this.enumProvider.getEnumValue(this.enumType, value, true);
    }
}

