/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import net.sf.mmm.util.lang.api.SimpleDatatype;

public enum BooleanEnum implements SimpleDatatype<Boolean>
{
    TRUE(Boolean.TRUE),
    FALSE(Boolean.FALSE),
    NULL(null);

    private final Boolean value;

    private BooleanEnum(Boolean value) {
        this.value = value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public static BooleanEnum fromValue(Boolean value) {
        if (value == null) {
            return NULL;
        }
        if (value.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }
}

