/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.exception.api;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import net.sf.mmm.util.exception.NlsBundleUtilExceptionRoot;
import net.sf.mmm.util.exception.api.NlsRuntimeException;
import net.sf.mmm.util.exception.api.NlsThrowable;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.api.NlsObject;
import net.sf.mmm.util.nls.base.ComposedNlsMessage;

public class ComposedException
extends NlsRuntimeException {
    private static final long serialVersionUID = 3290876155391059885L;
    public static final String MESSAGE_CODE = "Composed";
    private Throwable[] errors;

    public ComposedException(Throwable ... errors) {
        super(ComposedException.createBundle(NlsBundleUtilExceptionRoot.class).errorComposed(ComposedException.createSubMessage(errors)));
        this.errors = errors;
    }

    public ComposedException(NlsObject ... errors) {
        super(ComposedException.createBundle(NlsBundleUtilExceptionRoot.class).errorComposed(ComposedException.createSubMessage(errors)));
        this.errors = null;
    }

    private static NlsMessage createSubMessage(Object[] errors) {
        Object[] messages = new Object[errors.length];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = errors[i] == null ? null : (errors[i] instanceof NlsObject ? ((NlsObject)errors[i]).toNlsMessage() : (errors[i] instanceof Throwable ? ((Throwable)errors[i]).getLocalizedMessage() : errors[i]));
        }
        return new ComposedNlsMessage(messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(Locale locale, Appendable buffer) {
        super.printStackTrace(locale, buffer);
        if (this.errors != null) {
            try {
                Appendable appendable = buffer;
                synchronized (appendable) {
                    for (Throwable nested : this.errors) {
                        if (nested == null) continue;
                        buffer.append("Caused by: ");
                        buffer.append(StringUtil.LINE_SEPARATOR);
                        if (nested instanceof NlsThrowable) {
                            ((NlsThrowable)((Object)nested)).printStackTrace(locale, buffer);
                            continue;
                        }
                        if (buffer instanceof PrintStream) {
                            nested.printStackTrace((PrintStream)buffer);
                            continue;
                        }
                        if (buffer instanceof PrintWriter) {
                            nested.printStackTrace((PrintWriter)buffer);
                            continue;
                        }
                        StringWriter writer = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(writer);
                        nested.printStackTrace(printWriter);
                        printWriter.flush();
                        buffer.append(writer.toString());
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public String getCode() {
        return MESSAGE_CODE;
    }
}

