/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import java.util.Collections;
import java.util.List;
import net.sf.mmm.util.collection.api.GenericTreeNode;
import net.sf.mmm.util.collection.api.ListFactory;
import net.sf.mmm.util.collection.api.Node;
import net.sf.mmm.util.collection.base.ArrayListFactory;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;

public abstract class AbstractGenericTreeNode<CHILD extends Node<PARENT>, PARENT extends GenericTreeNode<CHILD, PARENT>>
implements GenericTreeNode<CHILD, PARENT> {
    private final transient List<CHILD> mutableChildList;
    private final List<CHILD> children;
    private PARENT parent;

    public AbstractGenericTreeNode() {
        this(null, ArrayListFactory.INSTANCE);
    }

    public AbstractGenericTreeNode(PARENT parent) {
        this(parent, ArrayListFactory.INSTANCE);
    }

    public AbstractGenericTreeNode(ListFactory listFactory) {
        this(null, listFactory);
    }

    public AbstractGenericTreeNode(PARENT parent, ListFactory listFactory) {
        this.parent = parent;
        this.mutableChildList = listFactory.create();
        this.children = Collections.unmodifiableList(this.mutableChildList);
    }

    @Override
    public PARENT getParent() {
        return this.parent;
    }

    protected void setParent(PARENT parent) {
        this.parent = parent;
    }

    @Override
    public List<CHILD> getChildren() {
        return this.children;
    }

    protected List<CHILD> getMutableChildList() {
        return this.mutableChildList;
    }

    protected void addChild(CHILD child) {
        if (child == null) {
            throw new NlsNullPointerException("child");
        }
        if (child.getParent() != this) {
            throw new NlsIllegalArgumentException(child);
        }
        this.mutableChildList.add(child);
    }

    protected void addChild(CHILD child, int index) {
        if (child == null) {
            throw new NlsNullPointerException("child");
        }
        if (child.getParent() != this) {
            throw new NlsIllegalArgumentException(child);
        }
        this.mutableChildList.add(index, child);
    }

    protected boolean removeChild(CHILD child) {
        if (child == null) {
            throw new NlsNullPointerException("child");
        }
        return this.mutableChildList.remove(child);
    }

    protected CHILD removeChild(int index) {
        return (CHILD)((Node)this.mutableChildList.remove(index));
    }

    @Override
    public boolean isAncestor(PARENT node) {
        if (node == null) {
            throw new NlsNullPointerException("node");
        }
        for (Object ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDescendant(CHILD node) {
        if (node == null) {
            throw new NlsNullPointerException("node");
        }
        for (GenericTreeNode descendant = (GenericTreeNode)node.getParent(); descendant != null; descendant = descendant.getParent()) {
            if (descendant != this) continue;
            return true;
        }
        return false;
    }
}

