/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.text.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.util.exception.api.DuplicateObjectException;
import net.sf.mmm.util.lang.api.SimpleDatatype;

public enum DiacriticalMark implements SimpleDatatype<Character>
{
    ACUTE('\u00b4', '\u0301', "acute accent"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u00e1');
            this.addComposition('\u00e6', '\u01fd');
            this.addComposition('c', '\u0107');
            this.addComposition('e', '\u00e9');
            this.addComposition('g', '\u01f5');
            this.addComposition('i', '\u00ed');
            this.addComposition('k', '\u1e31');
            this.addComposition('l', '\u013a');
            this.addComposition('n', '\u0144');
            this.addComposition('o', '\u00f3');
            this.addComposition('p', '\u1e55');
            this.addComposition('r', '\u0155');
            this.addComposition('s', '\u015b');
            this.addComposition('u', '\u00fa');
            this.addComposition('y', '\u00fd');
            this.addComposition('z', '\u017a');
            this.addComposition('A', '\u00c1');
            this.addComposition('\u00c6', '\u01fc');
            this.addComposition('C', '\u0106');
            this.addComposition('E', '\u00c9');
            this.addComposition('G', '\u01f4');
            this.addComposition('I', '\u00cd');
            this.addComposition('K', '\u1e30');
            this.addComposition('L', '\u0139');
            this.addComposition('N', '\u0143');
            this.addComposition('O', '\u00d3');
            this.addComposition('P', '\u1e54');
            this.addComposition('R', '\u0154');
            this.addComposition('S', '\u015a');
            this.addComposition('U', '\u00da');
            this.addComposition('Y', '\u00dd');
            this.addComposition('Z', '\u0179');
            this.addComposition('\u00e5', '\u01fb');
            this.addComposition('\u00c5', '\u01fa');
            this.addComposition('\u00f8', '\u01ff');
            this.addComposition('\u00d8', '\u01fe');
            this.addComposition('\u00fc', '\u01d8');
            this.addComposition('\u00dc', '\u01d7');
            this.addComposition('\u03d2', '\u03d3');
        }
    }
    ,
    BREVE('\u02d8', '\u0306', "breve"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u0103');
            this.addComposition('e', '\u0115');
            this.addComposition('g', '\u011f');
            this.addComposition('i', '\u012d');
            this.addComposition('o', '\u014f');
            this.addComposition('u', '\u016d');
            this.addComposition('A', '\u0102');
            this.addComposition('E', '\u0114');
            this.addComposition('G', '\u011e');
            this.addComposition('I', '\u012c');
            this.addComposition('O', '\u014e');
            this.addComposition('U', '\u016c');
            this.addComposition('\u0436', '\u04c2');
            this.addComposition('\u0416', '\u04c1');
            this.addComposition('\u0410', '\u04d0');
            this.addComposition('\u0430', '\u04d1');
            this.addComposition('\u0415', '\u04d6');
            this.addComposition('\u0435', '\u04d7');
        }
    }
    ,
    CARON('\u02c7', '\u030c', "caron"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u01ce');
            this.addComposition('c', '\u010d');
            this.addComposition('d', '\u010f');
            this.addComposition('e', '\u011b');
            this.addComposition('g', '\u01e7');
            this.addComposition('h', '\u021f');
            this.addComposition('i', '\u01d0');
            this.addComposition('j', '\u01f0');
            this.addComposition('k', '\u01e9');
            this.addComposition('l', '\u013e');
            this.addComposition('n', '\u0148');
            this.addComposition('o', '\u01d2');
            this.addComposition('r', '\u0159');
            this.addComposition('s', '\u0161');
            this.addComposition('t', '\u0165');
            this.addComposition('u', '\u01d4');
            this.addComposition('z', '\u017e');
            this.addComposition('A', '\u01cd');
            this.addComposition('C', '\u010c');
            this.addComposition('D', '\u010e');
            this.addComposition('E', '\u011a');
            this.addComposition('G', '\u01e6');
            this.addComposition('H', '\u021e');
            this.addComposition('I', '\u01cf');
            this.addComposition('K', '\u01e8');
            this.addComposition('L', '\u013d');
            this.addComposition('N', '\u0147');
            this.addComposition('O', '\u01d1');
            this.addComposition('R', '\u0158');
            this.addComposition('S', '\u0160');
            this.addComposition('T', '\u0164');
            this.addComposition('U', '\u01d3');
            this.addComposition('Z', '\u017d');
            this.addComposition('\u00fc', '\u01da');
            this.addComposition('\u00dc', '\u01d9');
            this.addComposition('\u01f1', '\u01c4');
            this.addComposition('\u01f3', '\u01c6');
            this.addComposition('\u01f2', '\u01c5');
        }
    }
    ,
    CEDILLA('\u00b8', '\u0327', "cedilla"){

        @Override
        protected void initialize() {
            this.addComposition('c', '\u00e7');
            this.addComposition('e', '\u0229');
            this.addComposition('g', '\u0123');
            this.addComposition('h', '\u1e29');
            this.addComposition('k', '\u0137');
            this.addComposition('l', '\u013c');
            this.addComposition('n', '\u0146');
            this.addComposition('r', '\u0157');
            this.addComposition('s', '\u015f');
            this.addComposition('t', '\u0163');
            this.addComposition('C', '\u00c7');
            this.addComposition('E', '\u0228');
            this.addComposition('G', '\u0122');
            this.addComposition('H', '\u1e28');
            this.addComposition('K', '\u0136');
            this.addComposition('L', '\u013b');
            this.addComposition('N', '\u0145');
            this.addComposition('R', '\u0156');
            this.addComposition('S', '\u015e');
            this.addComposition('T', '\u0162');
        }
    }
    ,
    CIRCUMFLEX('^', '\u0302', "circumflex accent"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u00e2');
            this.addComposition('c', '\u0109');
            this.addComposition('e', '\u00ea');
            this.addComposition('g', '\u011d');
            this.addComposition('h', '\u0125');
            this.addComposition('i', '\u00ee');
            this.addComposition('j', '\u0135');
            this.addComposition('o', '\u00f4');
            this.addComposition('s', '\u015d');
            this.addComposition('u', '\u00fb');
            this.addComposition('w', '\u0175');
            this.addComposition('y', '\u0177');
            this.addComposition('z', '\u1e91');
            this.addComposition('A', '\u00c2');
            this.addComposition('C', '\u0108');
            this.addComposition('E', '\u00ca');
            this.addComposition('G', '\u011c');
            this.addComposition('H', '\u0124');
            this.addComposition('I', '\u00ce');
            this.addComposition('J', '\u0134');
            this.addComposition('O', '\u00d4');
            this.addComposition('S', '\u015c');
            this.addComposition('U', '\u00db');
            this.addComposition('W', '\u0174');
            this.addComposition('Y', '\u0176');
            this.addComposition('Z', '\u1e90');
            this.addComposition('+', '\u2a23');
        }
    }
    ,
    DIAERESIS('\u00a8', '\u0308', "diaeresis"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u00e4');
            this.addComposition('e', '\u00eb');
            this.addComposition('i', '\u00ef');
            this.addComposition('o', '\u00f6');
            this.addComposition('u', '\u00fc');
            this.addComposition('y', '\u00ff');
            this.addComposition('A', '\u00c4');
            this.addComposition('E', '\u00cb');
            this.addComposition('I', '\u00cf');
            this.addComposition('O', '\u00d6');
            this.addComposition('U', '\u00dc');
            this.addComposition('Y', '\u0178');
            this.addComposition('\u00f9', '\u01dc');
            this.addComposition('\u00d9', '\u01db');
            this.addComposition('\u01d4', '\u01da');
            this.addComposition('\u01d3', '\u01d9');
            this.addComposition('\u0101', '\u01df');
            this.addComposition('\u0100', '\u01de');
            this.addComposition('\u014c', '\u022a');
            this.addComposition('\u014d', '\u022b');
            this.addComposition('\u016a', '\u01d5');
            this.addComposition('\u016b', '\u01d6');
            this.addComposition('\u00fa', '\u01d8');
            this.addComposition('\u00da', '\u01d7');
        }
    }
    ,
    DOT_ABOVE('\u02d9', '\u0307', "dot above"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u0227');
            this.addComposition('c', '\u010b');
            this.addComposition('e', '\u0117');
            this.addComposition('g', '\u0121');
            this.addComposition('n', '\u1e45');
            this.addComposition('o', '\u022f');
            this.addComposition('z', '\u017c');
            this.addComposition('A', '\u0226');
            this.addComposition('C', '\u010a');
            this.addComposition('E', '\u0116');
            this.addComposition('G', '\u0120');
            this.addComposition('I', '\u0130');
            this.addComposition('N', '\u1e44');
            this.addComposition('O', '\u022e');
            this.addComposition('Z', '\u017b');
            this.addComposition('\u0100', '\u01e0');
            this.addComposition('\u0101', '\u01e1');
            this.addComposition('\u014c', '\u0230');
            this.addComposition('\u014d', '\u0231');
        }
    }
    ,
    DOT_BELOW('\u0000', '\u0323', "dot below"){

        @Override
        protected void initialize() {
            this.addComposition('n', '\u1e47');
            this.addComposition('N', '\u1e46');
            this.addComposition('H', '\u1e24');
        }
    }
    ,
    DOUBLE_ACUTE('\u02dd', '\u030b', "double acute accent"){

        @Override
        protected void initialize() {
            this.addComposition('o', '\u0151');
            this.addComposition('u', '\u0171');
            this.addComposition('O', '\u0150');
            this.addComposition('U', '\u0170');
        }
    }
    ,
    DOUBLE_GRAVE('\u0000', '\u030f', "double grave accent"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u0201');
            this.addComposition('e', '\u0205');
            this.addComposition('i', '\u0209');
            this.addComposition('o', '\u020d');
            this.addComposition('r', '\u0211');
            this.addComposition('u', '\u0215');
            this.addComposition('A', '\u0200');
            this.addComposition('E', '\u0204');
            this.addComposition('I', '\u0208');
            this.addComposition('O', '\u020c');
            this.addComposition('R', '\u0210');
            this.addComposition('U', '\u0214');
            this.addComposition('Y', '\u1ef2');
        }
    }
    ,
    GRAVE('`', '\u0300', "grave accent"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u00e0');
            this.addComposition('e', '\u00e8');
            this.addComposition('i', '\u00ec');
            this.addComposition('n', '\u01f9');
            this.addComposition('o', '\u00f2');
            this.addComposition('u', '\u00f9');
            this.addComposition('A', '\u00c0');
            this.addComposition('E', '\u00c8');
            this.addComposition('I', '\u00cc');
            this.addComposition('N', '\u01f8');
            this.addComposition('O', '\u00d2');
            this.addComposition('U', '\u00d9');
            this.addComposition('\u00fc', '\u01dc');
            this.addComposition('\u00dc', '\u01db');
        }
    }
    ,
    HOOK_ABOVE('\u0000', '\u0309', "hook above"){

        @Override
        protected void initialize() {
            this.addComposition('b', '\u0253');
            this.addComposition('c', '\u0188');
            this.addComposition('d', '\u0257');
            this.addComposition('f', '\u0192');
            this.addComposition('g', '\u0260');
            this.addComposition('h', '\u0266');
            this.addComposition('k', '\u0199');
            this.addComposition('m', '\u0271');
            this.addComposition('p', '\u01a5');
            this.addComposition('q', '\u02a0');
            this.addComposition('s', '\u0282');
            this.addComposition('t', '\u01ad');
            this.addComposition('v', '\u028b');
            this.addComposition('y', '\u01b4');
            this.addComposition('z', '\u0225');
            this.addComposition('B', '\u0181');
            this.addComposition('C', '\u0187');
            this.addComposition('D', '\u018a');
            this.addComposition('F', '\u0191');
            this.addComposition('G', '\u0193');
            this.addComposition('K', '\u0198');
            this.addComposition('P', '\u01a4');
            this.addComposition('T', '\u01ac');
            this.addComposition('V', '\u01b2');
            this.addComposition('Y', '\u01b3');
            this.addComposition('Z', '\u0224');
            this.addComposition('\u025f', '\u0284');
            this.addComposition('\u03a5', '\u03d2');
        }
    }
    ,
    HORN_ABOVE('\u0000', '\u031b', "horn"){

        @Override
        protected void initialize() {
            this.addComposition('o', '\u01a1');
            this.addComposition('u', '\u01b0');
            this.addComposition('O', '\u01a0');
            this.addComposition('U', '\u01af');
        }
    }
    ,
    MACRON('\u00af', '\u0304', "macron"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u0101');
            this.addComposition('e', '\u0113');
            this.addComposition('i', '\u012b');
            this.addComposition('o', '\u014d');
            this.addComposition('u', '\u016b');
            this.addComposition('y', '\u0233');
            this.addComposition('A', '\u0100');
            this.addComposition('E', '\u0112');
            this.addComposition('I', '\u012a');
            this.addComposition('O', '\u014c');
            this.addComposition('U', '\u016a');
            this.addComposition('Y', '\u0232');
            this.addComposition('\u00c4', '\u01de');
            this.addComposition('\u00e4', '\u01df');
            this.addComposition('\u00d6', '\u022a');
            this.addComposition('\u00f6', '\u022b');
            this.addComposition('\u00dc', '\u01d5');
            this.addComposition('\u00fc', '\u01d6');
            this.addComposition('\u0226', '\u01e0');
            this.addComposition('\u0227', '\u01e1');
            this.addComposition('\u022e', '\u0230');
            this.addComposition('\u022f', '\u0231');
            this.addComposition('\u01ea', '\u01ec');
            this.addComposition('\u01eb', '\u01ed');
            this.addComposition('\u00d5', '\u022c');
            this.addComposition('\u00f5', '\u022d');
        }
    }
    ,
    OGONEK('\u02db', '\u0328', "ogonek"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u0105');
            this.addComposition('e', '\u0119');
            this.addComposition('i', '\u012f');
            this.addComposition('o', '\u01eb');
            this.addComposition('u', '\u0173');
            this.addComposition('A', '\u0104');
            this.addComposition('E', '\u0118');
            this.addComposition('I', '\u012e');
            this.addComposition('O', '\u01ea');
            this.addComposition('U', '\u0172');
            this.addComposition('\u014c', '\u01ec');
            this.addComposition('\u014d', '\u01ed');
        }
    }
    ,
    RING_ABOVE('\u02da', '\u030a', "ring above"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u00e5');
            this.addComposition('u', '\u016f');
            this.addComposition('A', '\u00c5');
            this.addComposition('U', '\u016e');
            this.addComposition('\u00e1', '\u01fb');
            this.addComposition('\u00c1', '\u01fa');
        }
    }
    ,
    SHORT_SOLIDUS_OVERLAY('/', '\u0337', "short solidus"){

        @Override
        protected void initialize() {
            this.addComposition('o', '\u00f8');
            this.addComposition('O', '\u00d8');
            this.addComposition('\u00f3', '\u01ff');
            this.addComposition('\u00d3', '\u01fe');
        }
    }
    ,
    SHORT_STROKE_OVERLAY('\u2013', '\u0335', "short stroke"){

        @Override
        protected void initialize() {
            this.addComposition('\u0237', '\u025f');
        }
    }
    ,
    TILDE('~', '\u0303', "tilde"){

        @Override
        protected void initialize() {
            this.addComposition('a', '\u00e3');
            this.addComposition('i', '\u0129');
            this.addComposition('n', '\u00f1');
            this.addComposition('o', '\u00f5');
            this.addComposition('u', '\u0169');
            this.addComposition('A', '\u00c3');
            this.addComposition('I', '\u0128');
            this.addComposition('N', '\u00d1');
            this.addComposition('O', '\u00d5');
            this.addComposition('U', '\u0168');
            this.addComposition('\u014c', '\u022c');
            this.addComposition('\u014d', '\u022d');
        }
    };

    private final char separateCharacter;
    private final char combiningCharacter;
    private final String title;
    private final Map<Character, Character> composeMap;
    private final Map<Character, Character> decomposeMap;
    private final Collection<Character> composedCharacters;

    private DiacriticalMark(char separateCharacter, char combiningChar, String title) {
        this.separateCharacter = separateCharacter;
        this.combiningCharacter = combiningChar;
        this.title = title;
        this.composeMap = new HashMap<Character, Character>();
        this.decomposeMap = new HashMap<Character, Character>();
        this.initialize();
        this.composedCharacters = Collections.unmodifiableCollection(this.composeMap.values());
    }

    protected abstract void initialize();

    protected void addComposition(char uncomposed, char composed) {
        Character c;
        Character u = Character.valueOf(uncomposed);
        Character old = this.composeMap.put(u, c = Character.valueOf(composed));
        if (old != null) {
            throw new DuplicateObjectException(old, u);
        }
        old = this.decomposeMap.put(c, u);
        if (old != null) {
            throw new DuplicateObjectException(old, u);
        }
    }

    public char getSeparateCharacter() {
        return this.separateCharacter;
    }

    public char getCombiningCharacter() {
        return this.combiningCharacter;
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.separateCharacter);
    }

    public Character compose(char character) {
        return this.composeMap.get(Character.valueOf(character));
    }

    public Character decompose(char character) {
        return this.decomposeMap.get(Character.valueOf(character));
    }

    public Collection<Character> getComposedCharacters() {
        return this.composedCharacters;
    }

    @Override
    public String toString() {
        return this.title;
    }
}

