/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import ma.glasnost.orika.BoundMapperFacade;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.Filter;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.Properties;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.impl.AggregateFilter;
import ma.glasnost.orika.impl.GeneratedObjectBase;
import ma.glasnost.orika.impl.Specifications;
import ma.glasnost.orika.impl.generator.AggregateSpecification;
import ma.glasnost.orika.impl.generator.CodeGenerationStrategy;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.Node;
import ma.glasnost.orika.impl.generator.Specification;
import ma.glasnost.orika.impl.generator.UsedConvertersContext;
import ma.glasnost.orika.impl.generator.UsedFiltersContext;
import ma.glasnost.orika.impl.generator.UsedMapperFacadesContext;
import ma.glasnost.orika.impl.generator.UsedTypesContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.NestedProperty;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.PropertyResolverStrategy;

public class SourceCodeContext {
    private static final AtomicInteger UNIQUE_CLASS_INDEX = new AtomicInteger();
    private StringBuilder sourceBuilder;
    private String classSimpleName;
    private String packageName;
    private String className;
    private CompilerStrategy compilerStrategy;
    private List<String> methods;
    private List<String> fields;
    private Class<?> superClass;
    private final UsedTypesContext usedTypes;
    private final UsedConvertersContext usedConverters;
    private final UsedFiltersContext usedFilters;
    private final UsedMapperFacadesContext usedMapperFacades;
    private final MapperFactory mapperFactory;
    private final CodeGenerationStrategy codeGenerationStrategy;
    private final StringBuilder logDetails;
    private final PropertyResolverStrategy propertyResolver;
    private final Map<AggregateSpecification, List<FieldMap>> aggregateFieldMaps;
    private final MappingContext mappingContext;
    private final Collection<Filter<Object, Object>> filters;
    private final boolean shouldCaptureFieldContext;

    public SourceCodeContext(String baseClassName, Class<?> superClass, MappingContext mappingContext, StringBuilder logDetails) {
        this.mapperFactory = (MapperFactory)mappingContext.getProperty((Object)Properties.MAPPER_FACTORY);
        this.codeGenerationStrategy = (CodeGenerationStrategy)mappingContext.getProperty((Object)Properties.CODE_GENERATION_STRATEGY);
        this.compilerStrategy = (CompilerStrategy)mappingContext.getProperty((Object)Properties.COMPILER_STRATEGY);
        this.propertyResolver = (PropertyResolverStrategy)mappingContext.getProperty((Object)Properties.PROPERTY_RESOLVER_STRATEGY);
        this.filters = (Collection)mappingContext.getProperty((Object)Properties.FILTERS);
        this.shouldCaptureFieldContext = (Boolean)mappingContext.getProperty((Object)Properties.CAPTURE_FIELD_CONTEXT);
        String safeBaseClassName = baseClassName.replace("[]", "$Array");
        this.sourceBuilder = new StringBuilder();
        this.superClass = superClass;
        int namePos = safeBaseClassName.lastIndexOf(".");
        if (namePos > 0) {
            this.packageName = safeBaseClassName.substring(0, namePos);
            this.classSimpleName = safeBaseClassName.substring(namePos + 1);
        } else {
            this.packageName = "ma.glasnost.orika.generated";
            this.classSimpleName = safeBaseClassName;
        }
        this.classSimpleName = this.makeUniqueClassName(this.classSimpleName);
        this.className = this.packageName + "." + this.classSimpleName;
        this.methods = new ArrayList<String>();
        this.fields = new ArrayList<String>();
        this.sourceBuilder.append("package " + this.packageName + ";\n\n");
        this.sourceBuilder.append("public class " + this.classSimpleName + " extends " + superClass.getCanonicalName() + " {\n");
        this.usedTypes = new UsedTypesContext();
        this.usedConverters = new UsedConvertersContext();
        this.usedFilters = new UsedFiltersContext();
        this.mappingContext = mappingContext;
        this.usedMapperFacades = new UsedMapperFacadesContext();
        this.logDetails = logDetails;
        this.aggregateFieldMaps = new LinkedHashMap<AggregateSpecification, List<FieldMap>>();
    }

    private String makeUniqueClassName(String name) {
        return name + System.nanoTime() + "$" + UNIQUE_CLASS_INDEX.getAndIncrement();
    }

    public boolean isDebugEnabled() {
        return this.logDetails != null;
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logDetails.append(msg);
        }
    }

    public void debugField(FieldMap fieldMap, String msg) {
        if (this.isDebugEnabled()) {
            this.logDetails.append(this.fieldTag(fieldMap));
            this.logDetails.append(msg);
        }
    }

    public String fieldTag(FieldMap fieldMap) {
        return "\n\t Field(" + fieldMap.getSource() + ", " + fieldMap.getDestination() + ") : ";
    }

    protected StringBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public Class<?> getSuperClass() {
        return this.superClass;
    }

    public String getClassSimpleName() {
        return this.classSimpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    List<String> getFields() {
        return this.fields;
    }

    List<String> getMethods() {
        return this.methods;
    }

    public boolean shouldMapNulls() {
        return (Boolean)this.mappingContext.getProperty((Object)Properties.SHOULD_MAP_NULLS);
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public void addMethod(String methodSource) {
        this.sourceBuilder.append("\n" + methodSource + "\n");
        this.methods.add(methodSource);
    }

    public void addField(String fieldSource) {
        this.sourceBuilder.append("\n" + fieldSource + "\n");
        this.fields.add(fieldSource);
    }

    public String toSourceFile() {
        return this.sourceBuilder.toString() + "\n}";
    }

    protected Class<?> compileClass() throws CompilerStrategy.SourceCodeGenerationException {
        return this.compilerStrategy.compileClass(this);
    }

    public <T extends GeneratedObjectBase> T getInstance() throws CompilerStrategy.SourceCodeGenerationException, InstantiationException, IllegalAccessException {
        GeneratedObjectBase instance = (GeneratedObjectBase)this.compileClass().newInstance();
        Object[] usedTypesArray = this.usedTypes.toArray();
        Object[] usedConvertersArray = this.usedConverters.toArray();
        Object[] usedMapperFacadesArray = this.usedMapperFacades.toArray();
        Object[] usedFiltersArray = this.usedFilters.toArray();
        if (this.logDetails != null) {
            if (usedTypesArray.length > 0) {
                this.logDetails.append("\n\t" + Type.class.getSimpleName() + "s used: " + Arrays.toString(usedTypesArray));
            }
            if (usedConvertersArray.length > 0) {
                this.logDetails.append("\n\t" + Converter.class.getSimpleName() + "s used: " + Arrays.toString(usedConvertersArray));
            }
            if (usedMapperFacadesArray.length > 0) {
                this.logDetails.append("\n\t" + BoundMapperFacade.class.getSimpleName() + "s used: " + Arrays.toString(usedMapperFacadesArray));
            }
            if (usedFiltersArray.length > 0) {
                this.logDetails.append("\n\t" + Filter.class.getSimpleName() + "s used: " + Arrays.toString(usedFiltersArray));
            }
        }
        instance.setUsedTypes((Type<Object>[])usedTypesArray);
        instance.setUsedConverters((Converter<Object, Object>[])usedConvertersArray);
        instance.setUsedMapperFacades((BoundMapperFacade<Object, Object>[])usedMapperFacadesArray);
        instance.setUsedFilters((Filter<Object, Object>[])usedFiltersArray);
        return (T)instance;
    }

    public String usedFilter(Filter<?, ?> filter) {
        int index = this.usedFilters.getIndex(filter);
        return "((" + Filter.class.getCanonicalName() + ")usedFilters[" + index + "])";
    }

    public String usedConverter(Converter<?, ?> converter) {
        int index = this.usedConverters.getIndex(converter);
        return "((" + Converter.class.getCanonicalName() + ")usedConverters[" + index + "])";
    }

    public String usedType(Type<?> type) {
        int index = this.usedTypes.getIndex(type);
        return "((" + Type.class.getCanonicalName() + ")usedTypes[" + index + "])";
    }

    private String usedMapperFacadeCall(Type<?> sourceType, Type<?> destinationType) {
        UsedMapperFacadesContext.UsedMapperFacadesIndex usedFacade = this.usedMapperFacades.getIndex(sourceType, destinationType, this.mapperFactory);
        String mapInDirection = usedFacade.isReversed ? "mapReverse" : "map";
        return "((" + BoundMapperFacade.class.getCanonicalName() + ")usedMapperFacades[" + usedFacade.index + "])." + mapInDirection + "";
    }

    public String callMapper(Type<?> sourceType, Type<?> destinationType, String sourceExpression, String destExpression) {
        return this.usedMapperFacadeCall(sourceType, destinationType) + "(" + sourceExpression + ", " + destExpression + ", mappingContext)";
    }

    public String callMapper(Type<?> sourceType, Type<?> destinationType, String sourceExpression) {
        return this.usedMapperFacadeCall(sourceType, destinationType) + "(" + sourceExpression + ", mappingContext)";
    }

    public String callMapper(VariableRef source, VariableRef destination) {
        return this.callMapper(source.type(), destination.type(), "" + source, "" + destination);
    }

    public String callMapper(VariableRef source, Type<?> destination) {
        return this.callMapper(source.type(), destination, "" + source);
    }

    public String usedMapperFacadeNewObjectCall(VariableRef source, VariableRef destination) {
        return this.newObjectFromMapper(source.type(), destination.type());
    }

    public String newObjectFromMapper(Type<?> sourceType, Type<?> destinationType) {
        UsedMapperFacadesContext.UsedMapperFacadesIndex usedFacade = this.usedMapperFacades.getIndex(sourceType, destinationType, this.mapperFactory);
        String instantiateMethod = usedFacade.isReversed ? "newObjectReverse" : "newObject";
        return "((" + BoundMapperFacade.class.getCanonicalName() + ")usedMapperFacades[" + usedFacade.index + "])." + instantiateMethod + "";
    }

    public String newObjectFromMapper(VariableRef source, Type<?> destinationType) {
        return this.newObjectFromMapper(source.type(), destinationType) + "(" + source.asWrapper() + ", mappingContext)";
    }

    public String usedType(VariableRef r) {
        return this.usedType(r.type());
    }

    public String newObject(VariableRef source, Type<?> destinationType) {
        if (destinationType.isPrimitive()) {
            return VariableRef.getDefaultValue(destinationType.getRawType());
        }
        if (destinationType.isString()) {
            return "null";
        }
        return this.newObjectFromMapper(source, destinationType);
    }

    public String assureContainerInstanceExists(FieldMap fieldMap) {
        Property destination = fieldMap.getDestination();
        Property source = fieldMap.getSource();
        if (destination.getContainer() instanceof NestedProperty) {
            VariableRef containerDestination = new VariableRef(destination.getContainer(), "destination");
            VariableRef containerSource = new VariableRef(source.getContainer(), "source");
            return this.assureInstanceExists(containerDestination, containerSource);
        }
        return "";
    }

    public String assureInstanceExists(VariableRef propertyRef, VariableRef source) {
        StringBuilder out = new StringBuilder();
        String end = "";
        if (source.isNullPossible()) {
            out.append(source.ifNotNull());
            out.append("{\n");
            end = "\n}\n";
        }
        for (VariableRef ref : propertyRef.getPath()) {
            if (!ref.isAssignable()) continue;
            SourceCodeContext.append(out, String.format("if((%s)) { \n", ref.isNull()), ref.assign(this.newObject(source, ref.type()), new Object[0]), "}");
        }
        out.append(end);
        return out.toString();
    }

    public static String statement(String str, Object ... args) {
        if (str != null && !"".equals(str.trim())) {
            String trimmed;
            String expr = String.format(str, args);
            String prefix = "";
            String suffix = "";
            if (!expr.startsWith("\n") || expr.startsWith("}")) {
                prefix = "\n";
            }
            if (!("".equals(trimmed = expr.trim()) || trimmed.endsWith(";") || trimmed.endsWith("}") || trimmed.endsWith("{") || trimmed.endsWith("("))) {
                suffix = "; ";
            }
            return prefix + expr + suffix;
        }
        if (str != null) {
            return str;
        }
        return "";
    }

    public static void append(StringBuilder out, String ... statements) {
        for (String statement : statements) {
            out.append(SourceCodeContext.statement(statement, new Object[0]));
        }
    }

    public static String join(List<?> list, String separator) {
        StringBuilder result = new StringBuilder();
        for (Object item : list) {
            result.append(item + separator);
        }
        return result.length() > 0 ? result.substring(0, result.length() - separator.length()) : "";
    }

    public static VariableRef entrySetRef(VariableRef s) {
        Type<Set> sourceEntryType = TypeFactory.valueOf(Set.class, MapEntry.entryType(s.type()));
        return new VariableRef(sourceEntryType, s + ".entrySet()");
    }

    public String currentElementComparator(Node source, Node dest, Node.NodeList srcNodes, Node.NodeList destNodes) {
        StringBuilder comparator = new StringBuilder();
        String or = "";
        HashSet<FieldMap> fieldMaps = new HashSet<FieldMap>();
        for (Node node : source.children) {
            if (node.value == null) continue;
            fieldMaps.add(node.value);
        }
        for (Node node : dest.children) {
            if (node.value == null) continue;
            fieldMaps.add(node.value);
        }
        HashSet<String> comparisons = new HashSet<String>();
        for (FieldMap fieldMap : fieldMaps) {
            if (fieldMap.is(Specifications.aMultiOccurrenceElementMap()) && fieldMap.isByDefault() || fieldMap.isExcluded() || fieldMap.isIgnored()) continue;
            VariableRef sourceRef = this.getVariableForComparison(fieldMap, srcNodes, true, source);
            VariableRef destRef = this.getVariableForComparison(fieldMap, destNodes, false, dest);
            if (sourceRef == null || destRef == null) continue;
            if (!sourceRef.isValidPropertyReference(this.propertyResolver)) {
                throw new IllegalStateException(sourceRef + " is not valid!!");
            }
            if (!destRef.isValidPropertyReference(this.propertyResolver)) {
                throw new IllegalStateException(destRef + " is not valid!!");
            }
            String code = this.compareFields(fieldMap, sourceRef, destRef, dest.elementRef.type(), null);
            if ("".equals(code) || !comparisons.add(code)) continue;
            comparator.append(or + "!(" + code + ")");
            or = " || ";
        }
        return comparator.toString();
    }

    private VariableRef getVariableForComparison(FieldMap fieldMap, Node.NodeList nodes, boolean useSource, Node defaultParent) {
        Property prop;
        Node destNode = Node.findFieldMap(fieldMap, nodes, useSource);
        Property property = prop = useSource ? fieldMap.getSource() : fieldMap.getDestination();
        if (destNode != null && destNode.parent != null) {
            VariableRef parentRef = destNode.parent.elementRef;
            if (this.isSelfOrParentComparison(destNode.parent, defaultParent)) {
                return new VariableRef(prop.getElement(), parentRef);
            }
            return null;
        }
        if (prop.getContainer() != null) {
            VariableRef parentRef = defaultParent.elementRef;
            return new VariableRef(parentRef.type(), parentRef.name());
        }
        VariableRef parentRef = defaultParent.elementRef;
        if (this.propertyResolver.existsProperty(parentRef.type(), prop.getExpression())) {
            return new VariableRef(prop, defaultParent.elementRef);
        }
        return new VariableRef(prop, useSource ? "source" : "destination");
    }

    private boolean isSelfOrParentComparison(Node node, Node reference) {
        Node parent = reference;
        while (parent != null) {
            if (parent.elementRef.equals(node.elementRef)) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    private Property root(Property prop) {
        Property root = prop;
        while (root.getContainer() != null) {
            root = root.getContainer();
        }
        return root;
    }

    public Set<FieldMap> getAssociatedMappings(Collection<FieldMap> fieldMaps, FieldMap map) {
        LinkedHashSet<FieldMap> associated = new LinkedHashSet<FieldMap>();
        associated.add(map);
        LinkedHashSet<FieldMap> unprocessed = new LinkedHashSet<FieldMap>(fieldMaps);
        unprocessed.remove(map);
        LinkedHashSet<String> nextRoundSources = new LinkedHashSet<String>();
        LinkedHashSet<String> nextRoundDestinations = new LinkedHashSet<String>();
        Set<String> thisRoundSources = Collections.singleton(this.root(map.getSource()).getExpression());
        Set<String> thisRoundDestinations = Collections.singleton(this.root(map.getDestination()).getExpression());
        while (!(unprocessed.isEmpty() || thisRoundSources.isEmpty() && thisRoundDestinations.isEmpty())) {
            Iterator iter = unprocessed.iterator();
            while (iter.hasNext()) {
                FieldMap f = (FieldMap)iter.next();
                boolean containsSource = thisRoundSources.contains(this.root(f.getSource()).getExpression());
                boolean containsDestination = thisRoundDestinations.contains(this.root(f.getDestination()).getExpression());
                if (containsSource && containsDestination) {
                    associated.add(f);
                    iter.remove();
                    continue;
                }
                if (containsSource) {
                    associated.add(f);
                    iter.remove();
                    nextRoundDestinations.add(f.getDestination().getName());
                    continue;
                }
                if (!containsDestination) continue;
                associated.add(f);
                iter.remove();
                nextRoundSources.add(f.getSource().getName());
            }
            thisRoundSources = nextRoundSources;
            thisRoundDestinations = nextRoundDestinations;
            nextRoundSources = new LinkedHashSet();
            nextRoundDestinations = new LinkedHashSet();
        }
        return associated;
    }

    public boolean aggregateSpecsApply(FieldMap fieldMap) {
        for (AggregateSpecification spec : this.codeGenerationStrategy.getAggregateSpecifications()) {
            if (!spec.appliesTo(fieldMap)) continue;
            List<FieldMap> fieldMaps = this.aggregateFieldMaps.get(spec);
            if (fieldMaps == null) {
                fieldMaps = new ArrayList<FieldMap>();
                this.aggregateFieldMaps.put(spec, fieldMaps);
            }
            fieldMaps.add(fieldMap);
            return true;
        }
        return false;
    }

    public String mapAggregateFields() {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<AggregateSpecification, List<FieldMap>> entry : this.aggregateFieldMaps.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            out.append(entry.getKey().generateMappingCode(entry.getValue(), this));
        }
        this.aggregateFieldMaps.clear();
        return out.toString();
    }

    public String mapFields(FieldMap fieldMap, VariableRef source, VariableRef destination) {
        StringBuilder out = new StringBuilder();
        StringBuilder closing = new StringBuilder();
        if (destination.isAssignable() || destination.type().isMultiOccurrence() || !destination.type().isImmutable()) {
            if (source.isNestedProperty()) {
                out.append(source.ifPathNotNull());
                out.append("{ \n");
                closing.append("\n}");
            }
            boolean mapNulls = AbstractSpecification.shouldMapNulls(fieldMap, this);
            if (destination.isNullPathPossible()) {
                if (!source.isPrimitive() && !mapNulls) {
                    out.append(source.ifNotNull());
                    out.append(" {\n");
                    closing.append("\n}");
                }
                out.append(this.assureInstanceExists(destination, source));
            }
            Converter<Object, Object> converter = this.getConverter(fieldMap, fieldMap.getConverterId());
            source.setConverter(converter);
            if (this.shouldCaptureFieldContext) {
                this.beginCaptureFieldContext(out, fieldMap, source, destination);
            }
            StringBuilder filterClosing = new StringBuilder();
            VariableRef[] filteredProperties = this.applyFilters(source, destination, out, filterClosing);
            source = filteredProperties[0];
            destination = filteredProperties[1];
            for (Specification spec : this.codeGenerationStrategy.getSpecifications()) {
                if (!spec.appliesTo(fieldMap)) continue;
                String code = spec.generateMappingCode(fieldMap, source, destination, this);
                if (code == null || "".equals(code)) {
                    throw new IllegalStateException("empty code returned for spec " + spec + ", sourceProperty = " + source + ", destinationProperty = " + destination);
                }
                out.append(code);
                break;
            }
            out.append((CharSequence)filterClosing);
            if (this.shouldCaptureFieldContext) {
                this.endCaptureFieldContext(out);
            }
            out.append(closing.toString());
        }
        return out.toString();
    }

    private void beginCaptureFieldContext(StringBuilder out, FieldMap fieldMap, VariableRef source, VariableRef dest) {
        out.append(String.format("mappingContext.beginMappingField(\"%s\", %s, %s, \"%s\", %s, %s);\ntry{\n", this.escapeQuotes(fieldMap.getSource().getExpression()), this.usedType(fieldMap.getAType()), source.asWrapper(), this.escapeQuotes(fieldMap.getDestination().getExpression()), this.usedType(fieldMap.getBType()), dest.asWrapper()));
    }

    private void endCaptureFieldContext(StringBuilder out) {
        out.append("} finally {\n\tmappingContext.endMappingField();\n}\n");
    }

    private String escapeQuotes(String string) {
        return string.replaceAll("(?<!\\\\)\"", "\\\\\"");
    }

    public VariableRef[] applyFilters(VariableRef sourceProperty, VariableRef destinationProperty, StringBuilder out, StringBuilder closing) {
        Filter<Object, Object> filter = this.getFilter(sourceProperty, destinationProperty);
        if (filter != null) {
            if (destinationProperty.isNestedProperty()) {
                out.append("if (");
                out.append(String.format("(%s && %s.shouldMap(%s, \"%s\", %s, %s, \"%s\", %s, mappingContext))", destinationProperty.pathNotNull(), this.usedFilter(filter), this.usedType(sourceProperty.type()), SourceCodeContext.varPath(sourceProperty), sourceProperty.asWrapper(), this.usedType(destinationProperty.type()), SourceCodeContext.varPath(destinationProperty), destinationProperty.asWrapper()));
                out.append(" || ");
                out.append(String.format("(%s && %s.shouldMap(%s, \"%s\", %s, %s, \"%s\", null, mappingContext))", destinationProperty.pathNull(), this.usedFilter(filter), this.usedType(sourceProperty.type()), SourceCodeContext.varPath(sourceProperty), sourceProperty.asWrapper(), this.usedType(destinationProperty.type()), SourceCodeContext.varPath(destinationProperty)));
                out.append(") {");
            } else {
                out.append(String.format("if (%s.shouldMap(%s, \"%s\", %s, %s, \"%s\", %s, mappingContext)) {", this.usedFilter(filter), this.usedType(sourceProperty.type()), SourceCodeContext.varPath(sourceProperty), sourceProperty.asWrapper(), this.usedType(destinationProperty.type()), SourceCodeContext.varPath(destinationProperty), destinationProperty.asWrapper()));
            }
            sourceProperty = this.getSourceFilter(sourceProperty, destinationProperty, filter);
            destinationProperty = this.getDestFilter(sourceProperty, destinationProperty, filter);
            closing.insert(0, "\n}\n");
        }
        return new VariableRef[]{sourceProperty, destinationProperty};
    }

    private static String varPath(VariableRef var) {
        List<VariableRef> path = var.getPath();
        if (path.isEmpty()) {
            return var.validVariableName();
        }
        return path.get(path.size() - 1).property().getExpression() + "." + var.validVariableName();
    }

    private VariableRef getDestFilter(final VariableRef src, final VariableRef dest, final Filter<Object, Object> filter) {
        if (filter.filtersDestination()) {
            return new VariableRef(dest.property(), dest.owner()){
                private String setter;

                @Override
                protected String setter() {
                    if (this.setter == null) {
                        String destinationValue = "%s";
                        if (dest.isPrimitive()) {
                            destinationValue = ClassUtil.getWrapperType(dest.rawType()).getCanonicalName() + ".valueOf(%s)";
                        }
                        String filteredValue = String.format("%s.filterDestination(%s, %s, \"%s\", %s, \"%s\", mappingContext)", SourceCodeContext.this.usedFilter(filter), destinationValue, SourceCodeContext.this.usedType(src.type()), src.validVariableName(), SourceCodeContext.this.usedType(dest.type()), dest.validVariableName()).replace("$$$", "%s");
                        this.setter = super.setter().replace("%s", dest.cast(filteredValue));
                    }
                    return this.setter;
                }
            };
        }
        return dest;
    }

    private VariableRef getSourceFilter(final VariableRef src, final VariableRef dest, final Filter<Object, Object> filter) {
        if (filter.filtersSource()) {
            return new VariableRef(src.property(), src.owner()){
                private String getter;
                {
                    super(property, name);
                    this.setConverter(src.getConverter());
                }

                @Override
                protected String getter() {
                    if (this.getter == null) {
                        String sourceValue = super.getter();
                        if (src.isPrimitive()) {
                            sourceValue = ClassUtil.getWrapperType(src.rawType()).getCanonicalName() + ".valueOf(" + sourceValue + ")";
                        }
                        this.getter = src.cast(String.format("%s.filterSource(%s, %s, \"%s\", %s, \"%s\", mappingContext)", SourceCodeContext.this.usedFilter(filter), sourceValue, SourceCodeContext.this.usedType(src.type()), src.validVariableName(), SourceCodeContext.this.usedType(dest.type()), dest.validVariableName()));
                    }
                    return this.getter;
                }
            };
        }
        return src;
    }

    private Filter<Object, Object> getFilter(VariableRef sourceProperty, VariableRef destinationProperty) {
        ArrayList<Filter<Object, Object>> applicableFilters = new ArrayList<Filter<Object, Object>>();
        for (Filter<Object, Object> filter : this.filters) {
            if (!filter.appliesTo(sourceProperty.property(), destinationProperty.property())) continue;
            applicableFilters.add(filter);
        }
        if (applicableFilters.isEmpty()) {
            return null;
        }
        if (applicableFilters.size() == 1) {
            return (Filter)applicableFilters.get(0);
        }
        return new AggregateFilter(applicableFilters);
    }

    public String compareFields(FieldMap fieldMap, VariableRef sourceProperty, VariableRef destinationProperty, Type<?> destinationType, StringBuilder logDetails) {
        StringBuilder out = new StringBuilder();
        out.append("(");
        if (sourceProperty.isNestedProperty()) {
            out.append(sourceProperty.pathNotNull());
            out.append(" && ");
        }
        if (destinationProperty.isNestedProperty() && !sourceProperty.isPrimitive()) {
            out.append(sourceProperty.notNull());
            out.append(" && ");
        }
        Converter<Object, Object> converter = this.getConverter(fieldMap, fieldMap.getConverterId());
        sourceProperty.setConverter(converter);
        for (Specification spec : this.codeGenerationStrategy.getSpecifications()) {
            if (!spec.appliesTo(fieldMap)) continue;
            String code = spec.generateEqualityTestCode(fieldMap, sourceProperty, destinationProperty, this);
            if (code == null || "".equals(code)) {
                throw new IllegalStateException("empty code returned for spec " + spec + ", sourceProperty = " + sourceProperty + ", destinationProperty = " + destinationProperty);
            }
            out.append(code);
            break;
        }
        out.append(")");
        return out.toString();
    }

    private Converter<Object, Object> getConverter(FieldMap fieldMap, String converterId) {
        Converter<Object, Object> converter = null;
        ConverterFactory converterFactory = this.mapperFactory.getConverterFactory();
        converter = converterId != null ? converterFactory.getConverter(converterId) : converterFactory.getConverter(fieldMap.getSource().getType(), fieldMap.getDestination().getType());
        return converter;
    }
}

