/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

final class XmlInputStream
extends InputStream {
    private static final byte[] XML_HEADER_START = new byte[]{60, 63, 120, 109, 108, 32};
    private static final byte[] XML_ENCODING_ATRIBUTE = new byte[]{101, 110, 99, 111, 100, 105, 110, 103, 61};
    private final InputStream delegate;
    private final byte[] buffer;
    private final int length;
    private int index = 0;
    private Charset charset;

    public XmlInputStream(InputStream delegate, Charset defaultCharset) throws IOException {
        this.delegate = delegate;
        this.buffer = new byte[128];
        this.length = this.delegate.read(this.buffer);
        String encoding = null;
        int bufferIndex = 0;
        if (this.length > 20) {
            boolean okay = true;
            for (byte c : XML_HEADER_START) {
                if (c == this.buffer[bufferIndex++]) continue;
                okay = false;
                break;
            }
            if (okay) {
                int encodingIndex = 0;
                while (bufferIndex < this.length) {
                    if (this.buffer[bufferIndex++] == XML_ENCODING_ATRIBUTE[encodingIndex]) {
                        byte quote;
                        if (++encodingIndex != XML_ENCODING_ATRIBUTE.length) continue;
                        if (bufferIndex >= this.length || (quote = this.buffer[bufferIndex++]) != 34 && quote != 39) break;
                        int encodingStartIndex = bufferIndex;
                        while (bufferIndex < this.length) {
                            if (quote != this.buffer[bufferIndex++]) continue;
                            encoding = new String(this.buffer, encodingStartIndex, bufferIndex - encodingStartIndex - 1);
                        }
                        break;
                    }
                    encodingIndex = 0;
                }
            }
        }
        if (encoding == null) {
            this.charset = defaultCharset;
        } else {
            try {
                this.charset = Charset.forName(encoding);
            }
            catch (RuntimeException e) {
                this.charset = defaultCharset;
            }
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int read() throws IOException {
        if (this.index < this.length) {
            return this.buffer[this.index++];
        }
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.index < this.length) {
            return super.read(b, off, len);
        }
        return this.delegate.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

