/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.impl;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.AbstractGenericType;
import net.sf.mmm.util.reflect.impl.CommonTypeVariables;

public class GenericTypeImpl<T>
extends AbstractGenericType<T> {
    private final GenericType<?> definingType;
    private final Type type;
    private final Class<? extends T> assignmentClass;
    private final Class<T> retrievalClass;
    private final Type[] typeArgs;
    private final GenericType<?>[] typesArguments;
    private GenericType<?> componentType;
    private GenericType<?> keyType;

    public GenericTypeImpl(Type type) {
        this(type, null);
    }

    public GenericTypeImpl(Type valueType, GenericType<?> definingType) {
        this(valueType, definingType, true);
    }

    protected GenericTypeImpl(Type valueType, GenericType<?> definingType, boolean init) {
        this.type = valueType;
        this.definingType = definingType;
        ClassBounds bounds = this.getClassBounds(this.type);
        this.assignmentClass = bounds.assignmentClass;
        this.retrievalClass = bounds.retrievalClass;
        if (valueType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)valueType;
            this.typeArgs = parameterizedType.getActualTypeArguments();
            this.typesArguments = new GenericType[this.typeArgs.length];
        } else {
            this.typeArgs = ReflectionUtil.NO_TYPES;
            this.typesArguments = NO_TYPES;
        }
        if (init) {
            this.init();
        }
    }

    protected final void init() {
        Type genericComponentType = null;
        TypeVariable<Class<Map>> genericKeyType = null;
        if (this.type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)this.type;
            genericComponentType = arrayType.getGenericComponentType();
        }
        if (genericComponentType == null) {
            TypeVariable<Class<Map>> keyTypeVariable = null;
            TypeVariable<Class<Object>> componentTypeVariable = null;
            if (this.retrievalClass.isArray()) {
                genericComponentType = this.retrievalClass.getComponentType();
            } else if (Collection.class.isAssignableFrom(this.retrievalClass)) {
                componentTypeVariable = CommonTypeVariables.TYPE_VARIABLE_COLLECTION_ELEMENT;
            } else if (Map.class.isAssignableFrom(this.retrievalClass)) {
                componentTypeVariable = CommonTypeVariables.TYPE_VARIABLE_MAP_VALUE;
                keyTypeVariable = CommonTypeVariables.TYPE_VARIABLE_MAP_KEY;
            }
            if (componentTypeVariable != null && (genericComponentType = this.resolveTypeVariable(componentTypeVariable, this)) == null) {
                genericComponentType = componentTypeVariable;
            }
            if (keyTypeVariable != null && (genericKeyType = this.resolveTypeVariable(keyTypeVariable, this)) == null) {
                genericKeyType = keyTypeVariable;
            }
        }
        this.componentType = genericComponentType == null ? null : this.create(genericComponentType, this.definingType);
        this.keyType = genericKeyType == null ? null : this.create(genericKeyType, this.definingType);
    }

    @Override
    protected GenericType<?> create(Type genericType) {
        return this.create(genericType, null);
    }

    protected AbstractGenericType<T> create(Type genericType, GenericType<?> genericDefiningType) {
        return new GenericTypeImpl<T>(genericType, genericDefiningType);
    }

    protected ClassBounds getClassBounds(Type currentType) {
        if (currentType instanceof Class) {
            return new ClassBounds((Class)currentType);
        }
        if (currentType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)currentType;
            return this.getClassBounds(pt.getRawType());
        }
        if (currentType instanceof WildcardType) {
            Class lowerBoundClass;
            Class upperBoundClass;
            WildcardType wt = (WildcardType)currentType;
            Type[] upper = wt.getUpperBounds();
            if (upper.length > 0) {
                ClassBounds bounds = this.getClassBounds(upper[0]);
                upperBoundClass = bounds.retrievalClass;
            } else {
                upperBoundClass = Object.class;
            }
            Type[] lower = wt.getLowerBounds();
            if (lower.length > 0) {
                ClassBounds bounds = this.getClassBounds(lower[0]);
                lowerBoundClass = bounds.assignmentClass;
            } else {
                lowerBoundClass = upperBoundClass;
            }
            return new ClassBounds(lowerBoundClass, upperBoundClass);
        }
        if (currentType instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)currentType;
            ClassBounds bounds = this.getClassBounds(gat.getGenericComponentType());
            Class<?> lower = this.getArrayClass(bounds.assignmentClass);
            Class<?> upper = bounds.assignmentClass == bounds.retrievalClass ? lower : this.getArrayClass(bounds.retrievalClass);
            return new ClassBounds(lower, upper);
        }
        if (currentType instanceof TypeVariable) {
            Type resolvedType;
            TypeVariable variable = (TypeVariable)currentType;
            if (this.definingType != null && (resolvedType = this.resolveTypeVariable(variable, this.definingType)) != null && resolvedType != variable) {
                return this.getClassBounds(resolvedType);
            }
            Type[] bounds = variable.getBounds();
            if (bounds.length > 0) {
                return this.getClassBounds(bounds[0]);
            }
        }
        return new ClassBounds(Object.class);
    }

    public Class<?> getArrayClass(Class<?> componentClass) {
        return Array.newInstance(componentClass, 0).getClass();
    }

    @Override
    public GenericType<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public GenericType<?> getKeyType() {
        return this.keyType;
    }

    @Override
    public GenericType<?> getDefiningType() {
        return this.definingType;
    }

    @Override
    public Class<? extends T> getAssignmentClass() {
        return this.assignmentClass;
    }

    @Override
    public Class<T> getRetrievalClass() {
        return this.retrievalClass;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getTypeArgumentCount() {
        return this.typesArguments.length;
    }

    @Override
    public GenericType<?> getTypeArgument(int index) {
        GenericType<?> result = this.typesArguments[index];
        if (result == null) {
            this.typesArguments[index] = result = this.create(this.typeArgs[index], this.definingType);
        }
        return result;
    }

    protected static class ClassBounds {
        private final Class<?> assignmentClass;
        private final Class<?> retrievalClass;

        public ClassBounds(Class<?> bound) {
            this(bound, bound);
        }

        public ClassBounds(Class<?> assignmentClass, Class<?> retrievalClass) {
            this.assignmentClass = assignmentClass;
            this.retrievalClass = retrievalClass;
        }

        public Class<?> getAssignmentClass() {
            return this.assignmentClass;
        }

        public Class<?> getRetrievalClass() {
            return this.retrievalClass;
        }
    }
}

