/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.util.Set;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.reflect.base.ResourceVisitor;

public class ClassNameCollector
implements ResourceVisitor {
    private static final String SUFFIX_CLASS = ".class";
    private final Set<String> classNameSet;
    private final Filter<? super String> filter;

    public ClassNameCollector(Set<String> classNameSet, Filter<? super String> filter) {
        this.classNameSet = classNameSet;
        this.filter = filter;
    }

    @Override
    public boolean visitPackage(String classpath) {
        return true;
    }

    @Override
    public void visitResource(String classpath) {
        String classname;
        if (classpath.endsWith(SUFFIX_CLASS) && this.filter.accept(classname = classpath.substring(0, classpath.length() - SUFFIX_CLASS.length()).replace('/', '.'))) {
            this.classNameSet.add(classname);
        }
    }
}

