/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.exception.api;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.UUID;
import net.sf.mmm.util.exception.api.ExceptionTruncation;
import net.sf.mmm.util.exception.api.ExceptionUtil;
import net.sf.mmm.util.exception.api.NlsThrowable;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;

public class GenericSerializableException
extends RuntimeException
implements NlsThrowable,
NlsMessage {
    private static final long serialVersionUID = -8387886697693002740L;
    private String originalExceptionName;
    private String code;
    private boolean technical;
    private UUID uuid;

    protected GenericSerializableException() {
    }

    public GenericSerializableException(Throwable cause, String message, String originalExceptionName, StackTraceElement[] stacktrace, boolean technical, String code, UUID uuid) {
        super(message, cause);
        this.setStackTrace(stacktrace);
        this.originalExceptionName = originalExceptionName;
        this.technical = technical;
        this.code = code;
        this.uuid = uuid;
    }

    @Override
    public GenericSerializableException createCopy(ExceptionTruncation truncation) {
        Throwable newCause = truncation.isRemoveCause() ? null : this.getCause();
        StackTraceElement[] newStacktrace = truncation.isRemoveStacktrace() ? ExceptionUtil.NO_STACKTRACE : this.getStackTrace();
        GenericSerializableException copy = new GenericSerializableException(newCause, this.getMessage(), this.originalExceptionName, newStacktrace, this.technical, this.code, this.uuid);
        if (!truncation.isRemoveSuppressed()) {
            for (Throwable suppressed : this.getSuppressed()) {
                copy.addSuppressed(suppressed);
            }
        }
        return copy;
    }

    public String getOriginalExceptionName() {
        return this.originalExceptionName;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public NlsMessage toNlsMessage() {
        return this;
    }

    @Override
    public String getInternationalizedMessage() {
        return this.getMessage();
    }

    @Override
    public int getArgumentCount() {
        return 0;
    }

    @Override
    public Object getArgument(String key) {
        return null;
    }

    @Override
    public Object getArgument(int index) {
        return null;
    }

    @Override
    public boolean isTechnical() {
        return this.technical;
    }

    @Override
    public boolean isForUser() {
        return true;
    }

    @Override
    public NlsMessage getNlsMessage() {
        return this;
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage();
    }

    @Override
    public void getLocalizedMessage(Locale locale, Appendable appendable) {
        this.getLocalizedMessage(locale, null, appendable);
    }

    @Override
    public String getLocalizedMessage(Locale locale, NlsTemplateResolver resolver) {
        return this.getLocalizedMessage();
    }

    @Override
    public void getLocalizedMessage(Locale locale, NlsTemplateResolver resolver, Appendable buffer) throws IllegalStateException {
        try {
            buffer.append(this.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public void printStackTrace(Locale locale, Appendable buffer) throws IllegalStateException {
        if (buffer instanceof PrintStream) {
            this.printStackTrace((PrintStream)buffer);
        } else if (buffer instanceof PrintWriter) {
            this.printStackTrace((PrintWriter)buffer);
        } else {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            this.printStackTrace(printWriter);
            printWriter.flush();
            try {
                buffer.append(writer.toString());
            }
            catch (IOException e) {
                throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault(), null).toString();
    }

    @Override
    public String toString(Locale locale) {
        return this.toString(locale, null).toString();
    }

    @Override
    public Appendable toString(Locale locale, Appendable appendable) {
        Appendable buffer = appendable;
        if (buffer == null) {
            buffer = new StringBuilder(32);
        }
        try {
            Class<?> myClass = this.getClass();
            buffer.append(myClass.getName());
            buffer.append(':');
            buffer.append(this.originalExceptionName);
            buffer.append(": ");
            if (!this.originalExceptionName.endsWith(this.code)) {
                buffer.append(this.code);
                buffer.append(": ");
            }
            buffer.append(this.getLocalizedMessage(locale));
            if (this.uuid != null) {
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append(this.uuid.toString());
            }
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }
}

