/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.util;

import ma.glasnost.orika.Converter;
import ma.glasnost.orika.Filter;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;

public abstract class Ordering<T> {
    public static final Ordering<MapperKey> MAPPER_KEY = new Ordering<MapperKey>(){

        @Override
        public OrderingRelation order(MapperKey mapper1, MapperKey mapper2) {
            return Ordering.compare(mapper1.getAType(), mapper1.getBType(), mapper2.getAType(), mapper2.getBType(), true);
        }
    };
    public static final Ordering<ClassMap<?, ?>> CLASSMAP = new Ordering<ClassMap<?, ?>>(){

        @Override
        public OrderingRelation order(ClassMap<?, ?> mapper1, ClassMap<?, ?> mapper2) {
            return Ordering.compare(mapper1.getAType(), mapper1.getBType(), mapper2.getAType(), mapper2.getBType(), false);
        }
    };
    public static final Ordering<Mapper<Object, Object>> MAPPER = new Ordering<Mapper<Object, Object>>(){

        @Override
        public OrderingRelation order(Mapper<Object, Object> mapper1, Mapper<Object, Object> mapper2) {
            return Ordering.compare(mapper1.getAType(), mapper1.getBType(), mapper2.getAType(), mapper2.getBType(), true);
        }
    };
    public static final Ordering<Filter<Object, Object>> FILTER = new Ordering<Filter<Object, Object>>(){

        @Override
        public OrderingRelation order(Filter<Object, Object> mapper1, Filter<Object, Object> mapper2) {
            return Ordering.compare(mapper1.getAType(), mapper1.getBType(), mapper2.getAType(), mapper2.getBType(), true);
        }
    };
    public static final Ordering<Converter<Object, Object>> CONVERTER = new Ordering<Converter<Object, Object>>(){

        @Override
        public OrderingRelation order(Converter<Object, Object> mapper1, Converter<Object, Object> mapper2) {
            return Ordering.compare(mapper1.getAType(), mapper1.getBType(), mapper2.getAType(), mapper2.getBType(), false);
        }
    };

    public abstract OrderingRelation order(T var1, T var2);

    private static final OrderingRelation compare(Type<?> aType1, Type<?> bType1, Type<?> aType2, Type<?> bType2, boolean isBidirectional) {
        if (aType1.equals(aType2) && bType1.equals(bType2) || aType1.equals(bType2) && aType2.equals(bType1)) {
            return OrderingRelation.EQUAL;
        }
        if (aType1.isAssignableFrom(aType2) && bType1.isAssignableFrom(bType2) || isBidirectional && aType1.isAssignableFrom(bType2) && bType1.isAssignableFrom(aType2)) {
            return OrderingRelation.BEFORE;
        }
        if (aType2.isAssignableFrom(aType1) && bType2.isAssignableFrom(bType1) || isBidirectional && aType2.isAssignableFrom(bType1) && bType2.isAssignableFrom(aType1)) {
            return OrderingRelation.AFTER;
        }
        return OrderingRelation.UNDEFINED;
    }

    public static enum OrderingRelation {
        EQUAL,
        BEFORE,
        AFTER,
        UNDEFINED;

    }
}

