/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.cli.commands;

import com.devonfw.cobigen.api.CobiGen;
import com.devonfw.cobigen.api.exception.InputReaderException;
import com.devonfw.cobigen.api.to.GenerableArtifact;
import com.devonfw.cobigen.api.to.GenerationReportTo;
import com.devonfw.cobigen.api.to.IncrementTo;
import com.devonfw.cobigen.api.to.TemplateTo;
import com.devonfw.cobigen.api.util.MavenUtil;
import com.devonfw.cobigen.api.util.Tuple;
import com.devonfw.cobigen.cli.CobiGenCLI;
import com.devonfw.cobigen.cli.commands.CommandCommons;
import com.devonfw.cobigen.cli.utils.CobiGenUtils;
import com.devonfw.cobigen.cli.utils.ParsingUtils;
import com.devonfw.cobigen.cli.utils.ValidationUtils;
import com.google.googlejavaformat.java.FormatterException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.JaccardDistance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Using an input file (Java entity or ETO, OpenAPI definition, XML...) can generate code to a location on your computer"}, name="generate", aliases={"g"}, mixinStandardHelpOptions=true)
public class GenerateCommand
extends CommandCommons {
    final double SELECTION_THRESHOLD = 0.1;
    @CommandLine.Parameters(index="0", arity="1..*", split=",", description={"Input files (Java entity or ETO, OpenAPI definition, XML...) that will be parsed by CobiGen and generate code from them. You can use glob patterns on the path, for using multiple input files. Also you can specify input files one by one separated by comma."})
    List<File> inputFiles = null;
    @CommandLine.Option(names={"--out", "-o"}, arity="0..1", description={"Location where the generated code will be stored."})
    File outputRootPath = null;
    @CommandLine.Option(names={"--increments", "-i"}, split=",", description={"List of increments that will be generated. They need to be specified with numbers separated by comma."})
    List<String> increments = null;
    @CommandLine.Option(names={"--templates", "-t"}, split=",", description={"List of templates that will be generated. They need to be specified with numbers separated by comma."})
    List<String> templates = null;
    private static Logger LOG = LoggerFactory.getLogger(CobiGenCLI.class);
    private static final Scanner inputReader = new Scanner(System.in);

    @Override
    public Integer doAction() throws Exception {
        if (!this.areArgumentsValid()) {
            return 1;
        }
        LOG.debug("Input files and output root path confirmed to be valid.");
        CobiGen cg = CobiGenUtils.initializeCobiGen(this.templatesProject);
        if (this.increments == null && this.templates != null) {
            Tuple<List<Object>, List<TemplateTo>> inputsAndArtifacts = this.preprocess(cg, TemplateTo.class);
            for (int i = 0; i < ((List)inputsAndArtifacts.getA()).size(); ++i) {
                this.generate(this.inputFiles.get(i).toPath(), ((List)inputsAndArtifacts.getA()).get(i), MavenUtil.getProjectRoot((Path)this.inputFiles.get(i).toPath(), (boolean)false), (List)inputsAndArtifacts.getB(), cg, TemplateTo.class);
            }
        } else {
            Tuple<List<Object>, List<IncrementTo>> inputsAndArtifacts = this.preprocess(cg, IncrementTo.class);
            for (int i = 0; i < ((List)inputsAndArtifacts.getA()).size(); ++i) {
                this.generate(this.inputFiles.get(i).toPath(), ((List)inputsAndArtifacts.getA()).get(i), MavenUtil.getProjectRoot((Path)this.inputFiles.get(i).toPath(), (boolean)false), (List)inputsAndArtifacts.getB(), cg, IncrementTo.class);
            }
        }
        return 0;
    }

    private <T extends GenerableArtifact> Tuple<List<Object>, List<T>> preprocess(CobiGen cg, Class<T> c) {
        boolean isIncrements = c.getSimpleName().equals(IncrementTo.class.getSimpleName());
        boolean firstIteration = true;
        List<Object> finalTos = new ArrayList();
        ArrayList<Object> generationInputs = new ArrayList<Object>();
        for (File inputFile : this.inputFiles) {
            String extension = inputFile.getName().toLowerCase();
            boolean isJavaInput = extension.endsWith(".java");
            boolean isOpenApiInput = extension.endsWith(".yaml") || extension.endsWith(".yml");
            try {
                List matching;
                Object input = cg.read(inputFile.toPath(), StandardCharsets.UTF_8, new Object[0]);
                List list = matching = isIncrements ? cg.getMatchingIncrements(input) : cg.getMatchingTemplates(input);
                if (matching.isEmpty()) {
                    ValidationUtils.printNoTriggersMatched(inputFile, isJavaInput, isOpenApiInput);
                }
                if (firstIteration) {
                    finalTos = matching;
                    firstIteration = false;
                } else {
                    finalTos = isIncrements ? CobiGenUtils.retainAllIncrements(this.toIncrementTo(finalTos), this.toIncrementTo(matching)) : CobiGenUtils.retainAllTemplates(this.toTemplateTo(finalTos), this.toTemplateTo(matching));
                }
                generationInputs.add(input);
            }
            catch (InputReaderException e) {
                LOG.error("Invalid input for CobiGen, please check your input file '{}'", (Object)inputFile.toString());
            }
        }
        if (finalTos.isEmpty()) {
            LOG.error("There are no common Templates/Increments which could be generated from every of your inputs. Please think about executing generation one by one input file.");
            throw new InputMismatchException("No compatible input files.");
        }
        List<IncrementTo> selectedGenerableArtifacts = isIncrements ? this.generableArtifactSelection(this.increments, this.toIncrementTo(finalTos), IncrementTo.class) : this.generableArtifactSelection(this.templates, this.toTemplateTo(finalTos), TemplateTo.class);
        return new Tuple(generationInputs, selectedGenerableArtifacts);
    }

    private List<IncrementTo> toIncrementTo(List<? extends GenerableArtifact> matching) {
        return matching;
    }

    private List<TemplateTo> toTemplateTo(List<? extends GenerableArtifact> matching) {
        return matching;
    }

    public boolean areArgumentsValid() {
        int index = 0;
        for (File inputFile : this.inputFiles) {
            if (!(inputFile = GenerateCommand.preprocessInputFile(inputFile)).exists()) {
                LOG.debug("We could not find input file: {}. But we will keep trying, maybe you are using relative paths", (Object)inputFile.getAbsolutePath());
                if (!ParsingUtils.parseRelativePath(this.inputFiles, inputFile, index)) {
                    LOG.error("Your <inputFile> '{}' has not been found", (Object)inputFile.toString());
                    return false;
                }
            }
            if (!inputFile.isDirectory()) continue;
            LOG.error("Your input file: {} is a directory. CobiGen cannot understand that. Please use files.", (Object)inputFile.getAbsolutePath());
            return false;
        }
        if (this.outputRootPath != null) {
            this.outputRootPath = GenerateCommand.preprocessInputFile(this.outputRootPath);
        }
        return ValidationUtils.isOutputRootPathValid(this.outputRootPath);
    }

    public <T extends GenerableArtifact> void generate(Path inputFile, Object input, Path inputProject, List<T> generableArtifacts, CobiGen cg, Class<T> c) {
        boolean isIncrements = c.getSimpleName().equals(IncrementTo.class.getSimpleName());
        if (this.outputRootPath == null) {
            this.setOutputRootPath(inputProject);
        }
        GenerationReportTo report = null;
        LOG.info("Generating {} for input '{}, this can take a while...", (Object)(isIncrements ? "increments" : "templates"), (Object)inputFile);
        report = cg.generate(input, generableArtifacts, Paths.get(this.outputRootPath.getAbsolutePath(), new String[0]), false, (task, progress) -> {});
        ValidationUtils.checkGenerationReport(report);
        Set<Path> generatedJavaFiles = report.getGeneratedFiles().stream().filter(e -> e.getFileName().endsWith(".java")).collect(Collectors.toSet());
        if (!generatedJavaFiles.isEmpty()) {
            try {
                ParsingUtils.formatJavaSources(generatedJavaFiles);
            }
            catch (FormatterException e2) {
                LOG.warn("Generation was successful but we were not able to format your code. Maybe you will see strange formatting.");
            }
        }
    }

    private void setOutputRootPath(Path inputProject) {
        LOG.info("As you did not specify where the code will be generated, we will use the project of your current Input file.");
        LOG.debug("Generating to: {}", (Object)inputProject);
        this.outputRootPath = inputProject.toFile();
    }

    private <T extends GenerableArtifact> List<T> generableArtifactSelection(List<String> userInputIncrements, List<T> matching, Class<T> c) {
        String artifactType;
        boolean isIncrements = c.getSimpleName().equals(IncrementTo.class.getSimpleName());
        List<Object> userSelection = new ArrayList<GenerableArtifact>();
        String string = artifactType = isIncrements ? "increment" : "template";
        if (userInputIncrements == null || userInputIncrements.size() < 1) {
            this.printFoundArtifacts(matching, isIncrements, artifactType, userInputIncrements);
            userInputIncrements = new ArrayList<String>();
            for (String userArtifact : GenerateCommand.getUserInput().split(",")) {
                userInputIncrements.add(userArtifact);
            }
        }
        for (int j = 0; j < userInputIncrements.size(); ++j) {
            String digitMatch;
            String currentSelectedArtifact = userInputIncrements.get(j);
            if (currentSelectedArtifact.matches(digitMatch = "\\d+")) {
                try {
                    int selectedArtifactNumber = Integer.parseInt(currentSelectedArtifact);
                    int index = selectedArtifactNumber - 1;
                    if (selectedArtifactNumber == 0) {
                        LOG.info("(0) All");
                        return matching;
                    }
                    userSelection.add(j, (GenerableArtifact)matching.get(index));
                    String artifactDescription = isIncrements ? ((IncrementTo)matching.get(index)).getDescription() : ((TemplateTo)matching.get(index)).getId();
                    LOG.info("(" + selectedArtifactNumber + ") " + artifactDescription);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("The {} number you have specified is out of bounds!", (Object)artifactType);
                    throw e;
                }
                catch (NumberFormatException e) {
                    LOG.error("Error parsing your input. You need to specify {}s using numbers separated by comma (2,5,6).", (Object)artifactType);
                    throw e;
                }
            }
            if ("ALL".equals(currentSelectedArtifact.toUpperCase())) {
                LOG.info("(0) All");
                return matching;
            }
            List<Object> possibleArtifacts = new ArrayList();
            possibleArtifacts = isIncrements ? this.search(currentSelectedArtifact, matching, IncrementTo.class) : this.search(currentSelectedArtifact, matching, TemplateTo.class);
            if (possibleArtifacts.size() > 1) {
                this.printFoundArtifacts(possibleArtifacts, isIncrements, artifactType, userInputIncrements);
            } else {
                if (possibleArtifacts.size() == 1) {
                    String artifactDescription = isIncrements ? ((IncrementTo)possibleArtifacts.get(0)).getDescription() : ((TemplateTo)possibleArtifacts.get(0)).getId();
                    LOG.info("Exact match found: {}.", (Object)artifactDescription);
                    userSelection.add((GenerableArtifact)possibleArtifacts.get(0));
                    return userSelection;
                }
                if (possibleArtifacts.size() < 1) {
                    LOG.info("No increment with that name has been found, Please provide correct increment name and try again ! Thank you");
                    throw new InputMismatchException("Wrong increment name");
                }
            }
            userSelection = this.artifactStringSelection(userSelection, possibleArtifacts, artifactType);
        }
        return userSelection;
    }

    private <T extends GenerableArtifact> void printFoundArtifacts(List<T> possibleArtifacts, boolean isIncrements, String artifactType, List<String> userInputIncrements) {
        if (userInputIncrements != null) {
            LOG.info("Here are the {}s that may match your search.", (Object)artifactType);
        }
        LOG.info("(0) All");
        for (GenerableArtifact artifact : possibleArtifacts) {
            String artifactDescription = isIncrements ? ((IncrementTo)artifact).getDescription() : ((TemplateTo)artifact).getId();
            LOG.info("(" + (possibleArtifacts.indexOf(artifact) + 1) + ") " + artifactDescription);
        }
        LOG.info("Please enter the number(s) of {}(s) that you want to generate separated by comma.", (Object)artifactType);
    }

    private <T extends GenerableArtifact> List<T> artifactStringSelection(List<T> userSelection, List<T> possibleArtifacts, String artifactType) {
        for (String userArtifact : GenerateCommand.getUserInput().split(",")) {
            try {
                if ("0".equals(userArtifact)) {
                    userSelection = possibleArtifacts;
                    return userSelection;
                }
                GenerableArtifact currentArtifact = (GenerableArtifact)possibleArtifacts.get(Integer.parseInt(userArtifact) - 1);
                if (userSelection.contains(currentArtifact)) continue;
                userSelection.add(currentArtifact);
            }
            catch (NumberFormatException e) {
                LOG.error("Error parsing your input. You need to specify {}s using numbers separated by comma (2,5,6).", (Object)artifactType);
                throw e;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error("Error parsing your input. Please give a valid number from the list above.");
                throw e;
            }
        }
        return userSelection;
    }

    private <T extends GenerableArtifact> List<T> search(String userInput, List<T> matching, Class<?> c) {
        boolean isIncrements = c.getSimpleName().equals(IncrementTo.class.getSimpleName());
        HashMap<GenerableArtifact, Double> scores = new HashMap<GenerableArtifact, Double>();
        for (int i = 0; i < matching.size(); ++i) {
            String description;
            if (!isIncrements) {
                description = ((TemplateTo)matching.get(i)).getId();
                JaccardDistance distance = new JaccardDistance();
                scores.put((GenerableArtifact)matching.get(i), distance.apply((CharSequence)description.toUpperCase(), (CharSequence)userInput.toUpperCase()));
                continue;
            }
            description = ((IncrementTo)matching.get(i)).getDescription();
            String id = ((IncrementTo)matching.get(i)).getId();
            JaccardDistance distance = new JaccardDistance();
            double descriptionDistance = distance.apply((CharSequence)description.toUpperCase(), (CharSequence)userInput.toUpperCase());
            double idDistance = distance.apply((CharSequence)id.toUpperCase(), (CharSequence)userInput.toUpperCase());
            scores.put((GenerableArtifact)matching.get(i), Math.min(idDistance, descriptionDistance));
        }
        Map sorted = scores.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(e -> (GenerableArtifact)e.getKey(), e -> (Double)e.getValue(), (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<GenerableArtifact> chosen = new ArrayList<GenerableArtifact>();
        for (GenerableArtifact artifact : sorted.keySet()) {
            String description;
            GenerableArtifact tmp;
            GenerableArtifact generableArtifact = tmp = isIncrements ? artifact : artifact;
            if (!isIncrements) {
                description = ((TemplateTo)artifact).getId();
                if (!description.toUpperCase().contains(userInput.toUpperCase()) && !((Double)sorted.get(artifact) <= 0.1)) continue;
                chosen.add(tmp);
                continue;
            }
            description = ((IncrementTo)artifact).getDescription();
            String id = ((IncrementTo)artifact).getId();
            if (description.equalsIgnoreCase(userInput) || id.equalsIgnoreCase(userInput)) {
                chosen.add(tmp);
                return chosen;
            }
            if (!description.toUpperCase().contains(userInput.toUpperCase()) && !id.toUpperCase().contains(userInput.toUpperCase()) && !((Double)sorted.get(artifact) <= 0.1)) continue;
            chosen.add(tmp);
        }
        return chosen;
    }

    public static String getUserInput() {
        String userInput = "";
        userInput = inputReader.nextLine();
        return userInput;
    }

    public static File preprocessInputFile(File inputFile) {
        String pattern;
        String path = inputFile.getPath();
        boolean matches = path.matches(pattern = "[\\\"|\\'](.+)[\\\"|\\']");
        if (matches) {
            path = path.replace("\"", "");
            path = path.replace("'", "");
            return new File(path);
        }
        return inputFile;
    }
}

