/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import com.shiqi.quickjs.ArrayTypeAdapter;
import com.shiqi.quickjs.InterfaceTypeAdapter;
import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSException;
import com.shiqi.quickjs.JSRuntime;
import com.shiqi.quickjs.JSValueAdapter;
import com.shiqi.quickjs.JavaTypes;
import com.shiqi.quickjs.StandardTypeAdapters;
import com.shiqi.quickjs.TypeAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QuickJS {
    private static final List<TypeAdapter.Factory> BUILT_IN_FACTORIES = new ArrayList<TypeAdapter.Factory>(4);
    private final List<TypeAdapter.Factory> factories;
    private final Map<Type, TypeAdapter<?>> adapterCache;

    private QuickJS(Builder builder) {
        ArrayList<TypeAdapter.Factory> factories = new ArrayList<TypeAdapter.Factory>(builder.factories.size() + BUILT_IN_FACTORIES.size());
        factories.addAll(builder.factories);
        factories.addAll(BUILT_IN_FACTORIES);
        this.factories = Collections.unmodifiableList(factories);
        this.adapterCache = new ConcurrentHashMap();
    }

    public <T> TypeAdapter<T> getAdapter(Type type) {
        Type newType = JavaTypes.removeSubtypeWildcard(JavaTypes.canonicalize(type));
        TypeAdapter<?> adapter = this.adapterCache.get(newType);
        if (adapter != null) {
            return adapter;
        }
        int size = this.factories.size();
        for (int i = 0; i < size; ++i) {
            adapter = this.factories.get(i).create(this, newType);
            if (adapter == null) continue;
            this.adapterCache.put(newType, adapter);
            return adapter;
        }
        throw new IllegalArgumentException("Can't find TypeAdapter for " + type);
    }

    public JSRuntime createJSRuntime() {
        long runtime = QuickJS.createRuntime();
        if (runtime == 0L) {
            throw new IllegalStateException("Cannot create JSRuntime instance");
        }
        return new JSRuntime(runtime, this);
    }

    static native long createRuntime();

    static native void setRuntimeMallocLimit(long var0, int var2);

    static native void setRuntimeMaxStackSize(long var0, int var2);

    static native void setRuntimeInterruptHandler(long var0, JSRuntime.InterruptHandler var2);

    static native void destroyRuntime(long var0);

    static native long createContext(long var0);

    static native void destroyContext(long var0);

    static native long createValueUndefined(long var0);

    static native long createValueNull(long var0);

    static native long createValueBoolean(long var0, boolean var2);

    static native long createValueInt(long var0, int var2);

    static native long createValueFloat64(long var0, double var2);

    static native long createValueString(long var0, String var2);

    static native long createValueObject(long var0);

    static native long createValueArray(long var0);

    static native long createValueArrayBufferZ(long var0, boolean[] var2, int var3, int var4);

    static native long createValueArrayBufferB(long var0, byte[] var2, int var3, int var4);

    static native long createValueArrayBufferC(long var0, char[] var2, int var3, int var4);

    static native long createValueArrayBufferS(long var0, short[] var2, int var3, int var4);

    static native long createValueArrayBufferI(long var0, int[] var2, int var3, int var4);

    static native long createValueArrayBufferJ(long var0, long[] var2, int var3, int var4);

    static native long createValueArrayBufferF(long var0, float[] var2, int var3, int var4);

    static native long createValueArrayBufferD(long var0, double[] var2, int var3, int var4);

    static native long createValueFunction(long var0, JSContext var2, Object var3, String var4, String var5, Type var6, Type[] var7, boolean var8);

    static native long createValueFunctionS(long var0, JSContext var2, String var3, String var4, String var5, Type var6, Type[] var7);

    static native long createValueJavaObject(long var0, Object var2);

    static native long[] createValuePromise(long var0);

    static native int getValueTag(long var0);

    static native boolean isValueArray(long var0, long var2);

    static native boolean isValueArrayBuffer(long var0, long var2);

    static native boolean isValueFunction(long var0, long var2);

    static native long getValueProperty(long var0, long var2, int var4);

    static native long getValueProperty(long var0, long var2, String var4);

    static native boolean setValueProperty(long var0, long var2, int var4, long var5);

    static native boolean setValueProperty(long var0, long var2, String var4, long var5);

    static native boolean[] toBooleanArray(long var0, long var2);

    static native byte[] toByteArray(long var0, long var2);

    static native char[] toCharArray(long var0, long var2);

    static native short[] toShortArray(long var0, long var2);

    static native int[] toIntArray(long var0, long var2);

    static native long[] toLongArray(long var0, long var2);

    static native float[] toFloatArray(long var0, long var2);

    static native double[] toDoubleArray(long var0, long var2);

    static native boolean getValueBoolean(long var0);

    static native int getValueInt(long var0);

    static native double getValueFloat64(long var0);

    static native String getValueString(long var0, long var2);

    static native Object getValueJavaObject(long var0, long var2);

    static native boolean defineValueProperty(long var0, long var2, int var4, long var5, int var7);

    static native boolean defineValueProperty(long var0, long var2, String var4, long var5, int var7);

    static native long invokeValueFunction(long var0, long var2, long var4, long[] var6);

    static native void destroyValue(long var0, long var2);

    static native JSException getException(long var0);

    static native long getGlobalObject(long var0);

    static native long evaluate(long var0, String var2, String var3, int var4);

    static native void evaluateBytecode(long var0, byte[] var2, int var3);

    static native byte[] compileJsToBytecode(long var0, String var2);

    static native int executePendingJob(long var0);

    static {
        BUILT_IN_FACTORIES.add(StandardTypeAdapters.FACTORY);
        BUILT_IN_FACTORIES.add(JSValueAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(ArrayTypeAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(InterfaceTypeAdapter.FACTORY);
        System.loadLibrary("quickjs-android");
    }

    public static class Builder {
        private final List<TypeAdapter.Factory> factories = new ArrayList<TypeAdapter.Factory>();

        public <T> Builder registerTypeAdapter(Type type, TypeAdapter<T> adapter) {
            return this.registerTypeAdapterFactory((depot, targetType) -> {
                if (JavaTypes.equals(type, targetType)) {
                    return adapter;
                }
                return null;
            });
        }

        public Builder registerTypeAdapterFactory(TypeAdapter.Factory factory) {
            this.factories.add(factory);
            return this;
        }

        public QuickJS build() {
            return new QuickJS(this);
        }
    }
}

