/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import androidx.annotation.Nullable;
import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.QuickJS;
import java.io.Closeable;

public class JSRuntime
implements Closeable {
    private long pointer;
    private final QuickJS quickJS;

    JSRuntime(long pointer, QuickJS quickJS) {
        this.pointer = pointer;
        this.quickJS = quickJS;
    }

    private void checkClosed() {
        if (this.pointer == 0L) {
            throw new IllegalStateException("The JSRuntime is closed");
        }
    }

    public synchronized void setMallocLimit(int mallocLimit) {
        this.checkClosed();
        if (mallocLimit == 0 || mallocLimit < -1) {
            throw new IllegalArgumentException("Only positive number and -1 are accepted as malloc limit");
        }
        QuickJS.setRuntimeMallocLimit(this.pointer, mallocLimit);
    }

    public synchronized void setMaxStackSize(int stackSize) {
        this.checkClosed();
        if (stackSize < 0) {
            throw new IllegalArgumentException("Only positive number and 0 are accepted as max stack size");
        }
        QuickJS.setRuntimeMaxStackSize(this.pointer, stackSize);
    }

    public synchronized void setInterruptHandler(@Nullable InterruptHandler interruptHandler) {
        this.checkClosed();
        QuickJS.setRuntimeInterruptHandler(this.pointer, interruptHandler);
    }

    public synchronized JSContext createJSContext() {
        this.checkClosed();
        long context = QuickJS.createContext(this.pointer);
        if (context == 0L) {
            throw new IllegalStateException("Cannot create JSContext instance");
        }
        return new JSContext(context, this.quickJS, this);
    }

    @Override
    public synchronized void close() {
        if (this.pointer != 0L) {
            long runtimeToClose = this.pointer;
            this.pointer = 0L;
            QuickJS.destroyRuntime(runtimeToClose);
        }
    }

    public static interface InterruptHandler {
        public boolean onInterrupt();
    }
}

