/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSDataException;
import com.shiqi.quickjs.JSNumber;

final class JSInt
extends JSNumber {
    private final int value;

    JSInt(long pointer, JSContext jsContext, int value) {
        super(pointer, jsContext);
        this.value = value;
    }

    private int getIntInRange(String javaType, int min, int max) {
        int value = this.value;
        if (min <= value && value <= max) {
            return value;
        }
        throw new JSDataException("Can't treat " + value + " as " + javaType);
    }

    @Override
    public byte getByte() {
        return (byte)this.getIntInRange("byte", -128, 127);
    }

    @Override
    public short getShort() {
        return (short)this.getIntInRange("short", Short.MIN_VALUE, Short.MAX_VALUE);
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }
}

