/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSRuntime;
import com.shiqi.quickjs.JSValue;
import com.shiqi.quickjs.QuickJS;
import com.shiqi.quickjs.TypeAdapter;
import java.lang.reflect.Type;

class JNIHelper {
    private static Type VOID_PRIMITIVE_TYPE = Void.TYPE;
    private static Type CHAR_PRIMITIVE_TYPE = Character.TYPE;
    private static Type BOOLEAN_PRIMITIVE_TYPE = Boolean.TYPE;
    private static Type BYTE_PRIMITIVE_TYPE = Byte.TYPE;
    private static Type SHORT_PRIMITIVE_TYPE = Short.TYPE;
    private static Type INT_PRIMITIVE_TYPE = Integer.TYPE;
    private static Type LONG_PRIMITIVE_TYPE = Long.TYPE;
    private static Type FLOAT_PRIMITIVE_TYPE = Float.TYPE;
    private static Type DOUBLE_PRIMITIVE_TYPE = Double.TYPE;

    JNIHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object jsValueToJavaValue(JSContext jsContext, Type type, long value) {
        JSRuntime jSRuntime = jsContext.jsRuntime;
        synchronized (jSRuntime) {
            Object t;
            block7: {
                JSValue jsValue = null;
                try {
                    jsContext.checkClosed();
                    TypeAdapter adapter = jsContext.quickJS.getAdapter(type);
                    jsValue = jsContext.wrapAsJSValue(value);
                    t = adapter.fromJSValue(jsContext, jsValue);
                    if (jsValue != null) break block7;
                }
                catch (Throwable throwable) {
                    if (jsValue == null) {
                        QuickJS.destroyValue(jsContext.pointer, value);
                    }
                    throw throwable;
                }
                QuickJS.destroyValue(jsContext.pointer, value);
            }
            return t;
        }
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, boolean value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, (Object)value);
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, char value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, Character.valueOf(value));
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, byte value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, (Object)value);
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, short value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, (Object)value);
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, int value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, (Object)value);
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, long value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, (Object)value);
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, float value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, Float.valueOf(value));
    }

    private static long javaValueToJSValue(JSContext jsContext, Type type, double value) {
        return JNIHelper.javaValueToJSValue(jsContext, type, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long javaValueToJSValue(JSContext jsContext, Type type, Object value) {
        JSRuntime jSRuntime = jsContext.jsRuntime;
        synchronized (jSRuntime) {
            jsContext.checkClosed();
            TypeAdapter<Object> adapter = jsContext.quickJS.getAdapter(type);
            return adapter.toJSValue((JSContext)jsContext, value).pointer;
        }
    }

    private static boolean isPrimitiveType(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    private static boolean isSameType(Type t1, Type t2) {
        return t1 == t2 || t1 != null && t1.equals(t2);
    }

    private static boolean unbox(Boolean value) {
        return value;
    }

    private static char unbox(Character value) {
        return value.charValue();
    }

    private static byte unbox(Byte value) {
        return value;
    }

    private static short unbox(Short value) {
        return value;
    }

    private static int unbox(Integer value) {
        return value;
    }

    private static long unbox(Long value) {
        return value;
    }

    private static float unbox(Float value) {
        return value.floatValue();
    }

    private static double unbox(Double value) {
        return value;
    }
}

