/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import androidx.annotation.Nullable;
import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSFunction;
import com.shiqi.quickjs.JSObject;
import com.shiqi.quickjs.JSValue;
import com.shiqi.quickjs.JavaMethod;
import com.shiqi.quickjs.JavaTypes;
import com.shiqi.quickjs.TypeAdapter;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class InterfaceTypeAdapter
extends TypeAdapter<Object> {
    static final TypeAdapter.Factory FACTORY = (depot, type) -> {
        Map<String, JavaMethod> methods = InterfaceTypeAdapter.getInterfaceMethods(type);
        if (methods == null) {
            return null;
        }
        return new InterfaceTypeAdapter(JavaTypes.getRawType(type), methods).nullable();
    };
    private final Class<?> rawType;
    private final Map<String, JavaMethod> methods;
    private static final JSValueHolderTag JS_VALUE_HOLDER_TAG = new JSValueHolderTag();

    @Nullable
    static Map<String, JavaMethod> getInterfaceMethods(Type type) {
        Class<?> rawType = JavaTypes.getRawType(type);
        if (!rawType.isInterface()) {
            return null;
        }
        HashMap<String, JavaMethod> methods = new HashMap<String, JavaMethod>();
        for (Method method : rawType.getMethods()) {
            Type returnType = JavaTypes.resolve(type, rawType, method.getGenericReturnType());
            if (returnType instanceof TypeVariable) {
                return null;
            }
            String name = method.getName();
            Type[] originParameterTypes = method.getGenericParameterTypes();
            Object[] parameterTypes = new Type[originParameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = JavaTypes.resolve(type, rawType, originParameterTypes[i]);
                if (!(parameterTypes[i] instanceof TypeVariable)) continue;
                return null;
            }
            JavaMethod oldMethod = (JavaMethod)methods.get(name);
            if (oldMethod != null) {
                if (!Arrays.equals(oldMethod.parameterTypes, parameterTypes)) {
                    return null;
                }
                if (returnType.equals(oldMethod.returnType) || JavaTypes.getRawType(returnType).isAssignableFrom(JavaTypes.getRawType(oldMethod.returnType))) continue;
            }
            methods.put(name, new JavaMethod(returnType, name, (Type[])parameterTypes));
        }
        return methods;
    }

    private InterfaceTypeAdapter(Class<?> rawType, Map<String, JavaMethod> methods) {
        this.rawType = rawType;
        this.methods = methods;
    }

    @Override
    public JSValue toJSValue(JSContext context, Object value) {
        if (value instanceof JSValueHolder) {
            return ((JSValueHolder)value).getJSValue(JS_VALUE_HOLDER_TAG);
        }
        JSObject jo = context.createJSObject(value);
        for (JavaMethod method : this.methods.values()) {
            jo.setProperty(method.name, (JSValue)context.createJSFunction(value, method));
        }
        return jo;
    }

    @Override
    public Object fromJSValue(JSContext context, JSValue value) {
        JSObject jo = value.cast(JSObject.class);
        Object object = jo.getJavaObject();
        if (this.rawType.isInstance(object)) {
            return object;
        }
        return Proxy.newProxyInstance(this.rawType.getClassLoader(), new Class[]{this.rawType, JSValueHolder.class}, (proxy, method, args) -> {
            int parameterNumber;
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (args != null && args.length == 1 && args[0] == JS_VALUE_HOLDER_TAG) {
                return value;
            }
            String name = method.getName();
            JavaMethod simpleMethod = this.methods.get(name);
            if (simpleMethod == null) {
                throw new NoSuchMethodException("Can't find method: " + name);
            }
            int n = parameterNumber = args != null ? args.length : 0;
            if (parameterNumber != simpleMethod.parameterTypes.length) {
                throw new IllegalStateException("Parameter number doesn't match: " + name);
            }
            JSValue[] parameters = new JSValue[parameterNumber];
            for (int i = 0; i < parameterNumber; ++i) {
                Type type = simpleMethod.parameterTypes[i];
                TypeAdapter<Object> adapter = context.quickJS.getAdapter(type);
                parameters[i] = adapter.toJSValue(context, args[i]);
            }
            Type resultType = simpleMethod.returnType;
            TypeAdapter resultAdapter = context.quickJS.getAdapter(resultType);
            JSFunction function = jo.getProperty(name).cast(JSFunction.class);
            JSValue result = function.invoke(jo, parameters);
            return resultAdapter.fromJSValue(context, result);
        });
    }

    private static interface JSValueHolder {
        public JSValue getJSValue(JSValueHolderTag var1);
    }

    private static class JSValueHolderTag {
        private JSValueHolderTag() {
        }
    }
}

