/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.utils;

import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Process;
import android.os.UserHandle;
import com.devicenative.dna.utils.DNALogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;

public class DNAUtils {
    private static final ConcurrentHashMap<String, Integer> userHandleCache = new ConcurrentHashMap();
    private static final Pattern USER_HANDLE_PATTERN = Pattern.compile("\\{(\\d+)\\}");

    public static List<String> convertJSONArrayToStrings(JSONArray jsonArray) throws JSONException {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            strings.add(jsonArray.getString(i));
        }
        return strings;
    }

    public static int readPidFromUserHandleString(String userHandle) {
        if (userHandle == null || userHandle.isEmpty()) {
            return -1;
        }
        Integer cached = userHandleCache.get(userHandle);
        if (cached != null) {
            return cached;
        }
        Matcher m = USER_HANDLE_PATTERN.matcher(userHandle);
        if (m.find()) {
            int userId = Integer.parseInt(m.group(1));
            userHandleCache.put(userHandle, userId);
            return userId;
        }
        return -1;
    }

    public static UserHandle getUserHandleFromFormattedString(String formattedUserIdString) {
        try {
            if (formattedUserIdString.startsWith("UserHandle{") && formattedUserIdString.endsWith("}")) {
                String userIdNumStr = formattedUserIdString.substring(11, formattedUserIdString.length() - 1);
                int userId = Integer.parseInt(userIdNumStr);
                Class<?> userHandleClass = Class.forName("android.os.UserHandle");
                Method ofMethod = userHandleClass.getMethod("of", Integer.TYPE);
                return (UserHandle)ofMethod.invoke(null, userId);
            }
        }
        catch (Exception e) {
            DNALogger.e("DNAPackageChangedReceiver: Error creating UserHandle: " + e.getMessage());
        }
        return Process.myUserHandle();
    }

    public static String formatUserIdString(String userIdString) {
        if (userIdString == null || userIdString.isEmpty()) {
            UserHandle currentUserHandle = Process.myUserHandle();
            return currentUserHandle.toString();
        }
        try {
            String userIdNumStr = null;
            if (userIdString.startsWith("UserHandle{") && userIdString.endsWith("}")) {
                return userIdString;
            }
            if (userIdString.startsWith("{") && userIdString.endsWith("}")) {
                userIdNumStr = userIdString.substring(1, userIdString.length() - 1);
                return "UserHandle{" + userIdNumStr + "}";
            }
            int userId = Integer.parseInt(userIdString);
            return "UserHandle{" + userId + "}";
        }
        catch (Exception e) {
            DNALogger.e("DNAPackageChangedReceiver: Error formatting user ID: " + e.getMessage());
            UserHandle currentUserHandle = Process.myUserHandle();
            return currentUserHandle.toString();
        }
    }

    public static boolean isArchived(ApplicationInfo info) {
        if (Build.VERSION.SDK_INT < 34) {
            return false;
        }
        try {
            Field f = ApplicationInfo.class.getField("isArchived");
            return f.getBoolean(info);
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            try {
                Field flagF = ApplicationInfo.class.getField("FLAG_ARCHIVED");
                int flag = flagF.getInt(null);
                return (info.flags & flag) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static boolean isSuspended(ApplicationInfo info) {
        try {
            return (info.flags & 0x40000000) != 0;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            try {
                Field f = ApplicationInfo.class.getField("FLAG_SUSPENDED");
                int FLAG_SUSPENDED = f.getInt(null);
                return (info.flags & FLAG_SUSPENDED) != 0;
            }
            catch (ReflectiveOperationException ignored) {
                return false;
            }
        }
    }

    public static String extractActivityName(String componentName) {
        int slashIndex;
        if (componentName == null || componentName.isEmpty()) {
            return componentName;
        }
        String workingString = componentName;
        if (componentName.startsWith("ComponentInfo{") && componentName.endsWith("}")) {
            workingString = componentName.substring(14, componentName.length() - 1);
        }
        if ((slashIndex = workingString.indexOf(47)) == -1) {
            return componentName;
        }
        String afterSlash = workingString.substring(slashIndex + 1);
        int hashIndex = afterSlash.indexOf(35);
        if (hashIndex != -1) {
            afterSlash = afterSlash.substring(0, hashIndex);
        }
        return afterSlash;
    }
}

