/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.utils;

import android.content.Context;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import java.util.List;
import org.json.JSONObject;

public class DNAStatsLogger {
    private static String convertJsonToString(JSONObject jsonObject) {
        return jsonObject.toString();
    }

    public static void logInternal(Context context, String event, Integer value, JSONObject metadata) {
        new Thread(() -> DNAStatsLogger.logInternalSync(context, event, value, metadata)).start();
    }

    public static void logInternalSync(Context context, String event, Integer value, JSONObject metadata) {
        if (value == null) {
            value = -1;
        }
        DNALogger.i("DNAStatsLogger: logInternalSync: " + event);
        DNAPreferences dnaPreferences = DNAPreferences.getInstance(context);
        DNADatabaseInterface.insertStatRecord(context, event, value, DNAStatsLogger.convertJsonToString(metadata), dnaPreferences.getAppPackageName());
    }

    public static void logBatchInternal(Context context, List<StatItem> statItems) {
        new Thread(() -> DNAStatsLogger.logBatchInternalSync(context, statItems)).start();
    }

    public static void logBatchInternalSync(Context context, List<StatItem> statItems) {
        DNALogger.i("DNAStatsLogger: logBatchInternalSync: " + statItems.size());
        DNAPreferences dnaPreferences = DNAPreferences.getInstance(context);
        for (StatItem statItem : statItems) {
            DNADatabaseInterface.insertStatRecord(context, statItem.event, statItem.value, DNAStatsLogger.convertJsonToString(statItem.metadata), dnaPreferences.getAppPackageName());
        }
    }

    public static class StatItem {
        final String event;
        final Integer value;
        final JSONObject metadata;

        public StatItem(String event, Integer value, JSONObject metadata) {
            this.event = event;
            this.value = value == null ? Integer.valueOf(-1) : value;
            this.metadata = metadata;
        }
    }
}

