/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.AtomicFile;
import com.devicenative.dna.utils.DNALogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DNAPreferences {
    static final String DNA_BASE_URL = "https://api.devicenative.com/v2/";
    static final int INTERVAL_RETRY = 1000;
    static final int MAX_RETRIES = 3;
    static final int TIMEOUT = 5500;
    static final int CONNECT_TIMEOUT = 10000;
    public static final int LOCAL_DATA_REFRESH_INTERVAL = 3600000;
    public static final int USAGE_SYNC_INTERVAL = 2000;
    private static final String SHARED_PREF_FILE = "device_native_shared_pref";
    private static final String USER_AGENT_SHARED_PREF_FILE = "device_native_config_shared_pref.txt";
    private static final String KEY_BASE_URL = "dna_server_url";
    private static final String KEY_DEVICE_KEY = "dna_device_key";
    private static final String KEY_SESSION_ID = "dna_session_id";
    private static final String KEY_APPS_LOADED = "dna_apps_loaded";
    private static final String KEY_REQUEST_APP_RELOAD = "dna_request_app_reload";
    private static final String KEY_SHORTCUTS_LOADED = "dna_shortcuts_loaded";
    private static final String KEY_REFRESH_INTERVAL = "dna_refresh_interval";
    private static final String KEY_LOCAL_REFRESH_INTERVAL = "dna_local_refresh_interval";
    private static final String KEY_CODE_VERSION_ID = "dna_code_version_id";
    private static final String KEY_AD_SELECTION_CODE = "dna_ad_selection_code";
    private static final String KEY_AD_BUNDLE_ID = "dna_ad_bundle_id";
    private static final String KEY_METADATA_VERSION_ID = "dna_metadata_version_id";
    private static final String KEY_BLACKLIST_VERSION_ID = "dna_blacklist_version_id";
    private static final String KEY_BLACKLIST_APPS = "dna_blacklist_apps";
    private static final String KEY_ANDROID_VERSION = "dna_android_version";
    private static final String KEY_START_TIME = "dna_start_time";
    private static final String KEY_CPU_COUNT = "dna_cpu_count";
    private static final String KEY_MAX_MEMORY = "dna_max_memory";
    private static final String KEY_DEVICE_MODE = "dna_device_model";
    private static final String KEY_APP_VERSION = "dna_app_version";
    private static final String KEY_APP_PACKAGE_NAME = "dna_app_package_name";
    private static final String KEY_LAST_WAKE_TIME = "dna_last_wake_time";
    private static final String KEY_LAST_API_SYNC_TIME = "dna_last_api_sync_time";
    private static final String KEY_LAST_USAGE_SYNC_TIME = "dna_last_usage_sync_time";
    private static final String KEY_VTA_ENABLED = "dna_vta_enabled";
    private static final String KEY_INSTALL_ADS_ENABLED = "dna_install_ads_enabled";
    private static final String KEY_WEB_ADS_ENABLED = "dna_web_ads_enabled";
    private static final String KEY_ORGANIC_ADS_ENABLED = "dna_organic_ads_enabled";
    private static final String KEY_ORGANIC_ADS_ONLY = "dna_organic_ads_only";
    private static final String KEY_PAID_ORGANIC_BOOST_ENABLED = "dna_paid_organic_boost_enabled";
    private static final String KEY_ADID = "dna_adid";
    private static final String KEY_FIRST_USAGE_READ = "dna_first_usage_read";
    private static final String KEY_ADID_USAGE_ENABLED = "dna_adid_usage_enabled";
    private static final String KEY_APP_USAGE_DISABLED = "dna_app_usage_disabled";
    private static final String KEY_AUTO_DEEP_LINK_ENABLED = "dna_auto_deep_link_enabled";
    private static final String KEY_AD_CACHE_TIMEOUT = "dna_ad_cache_timeout";
    private static final String KEY_IMPRESSION_BLACKOUT_WINDOW = "dna_impression_blackout_window";
    private static final String KEY_USAGE_STATS_ENABLED = "dna_usage_stats_enabled";
    private static final String KEY_REPLACE_GOOGLE_PLAY_URL = "dna_replace_google_play";
    private static final String KEY_PLAY_STORE_REPLACEMENT_URL = "dna_play_store_replacement_url";
    private static final String KEY_CONFIG_ADS_DISABLED = "dna_config_ads_disabled";
    private static final String KEY_CONFIG_SEARCH_ADS_DISABLED = "dna_config_search_ads_disabled";
    private static final String KEY_CONFIG_SEARCH_INSTALL_ADS_DISABLED = "dna_config_search_install_ads_disabled";
    private static final String KEY_CONFIG_REC_ADS_DISABLED = "dna_config_rec_ads_disabled";
    private static final String KEY_CONFIG_REC_INSTALL_ADS_DISABLED = "dna_config_rec_install_ads_disabled";
    private static final String KEY_CONFIG_GAID_DISABLED = "dna_config_ads_disabled";
    private static final String KEY_CONFIG_APP_USAGE_DISABLED = "dna_config_ads_disabled";
    private static final String KEY_CONFIG_COUNTRY_OVERRIDE = "dna_config_country_override";
    private static final String KEY_CONFIG_CARRIER_VALUE = "dna_config_carrier_value";
    private static final String KEY_DEBUG_MODE = "dna_debug_mode";
    private static final String KEY_USER_AGENT = "dna_user_agent";
    private static final String KEY_RETRY_COUNT = "dna_retry_count";
    private static final String KEY_RETRY_INTERVAL = "dna_retry_interval";
    private static final String KEY_TIMEOUT = "dna_timeout";
    private static final String KEY_CONNECT_TIMEOUT = "dna_connect_timeout";
    private static final String KEY_HIDDEN_PACKAGES = "dna_hidden_packages";
    private static final String KEY_HIDDEN_COMPONENTS = "dna_hidden_components";
    private static DNAPreferences dnaPreferences_ = null;
    private SharedPreferences appSharedPrefs_;
    private SharedPreferences.Editor prefsEditor_;

    private DNAPreferences(Context context) {
        this.init(context);
    }

    public void init(Context context) {
        this.appSharedPrefs_ = context.getSharedPreferences(SHARED_PREF_FILE, 0);
        this.prefsEditor_ = this.appSharedPrefs_.edit();
    }

    public static DNAPreferences getInstance(Context context) {
        if (dnaPreferences_ == null) {
            dnaPreferences_ = new DNAPreferences(context);
        }
        return dnaPreferences_;
    }

    public static DNAPreferences getInstance() {
        return dnaPreferences_;
    }

    public static void shutDown() {
        if (dnaPreferences_ != null) {
            DNAPreferences.dnaPreferences_.prefsEditor_ = null;
        }
        dnaPreferences_ = null;
    }

    public void setAPIUrl(String url) {
        this.setString(KEY_BASE_URL, url);
    }

    public String getAPIUrl() {
        return this.getString(KEY_BASE_URL, DNA_BASE_URL);
    }

    public void setDebugMode(boolean debugMode) {
        this.setBool(KEY_DEBUG_MODE, debugMode);
        DNALogger.updateDebugMode(debugMode);
    }

    public boolean getDebugMode() {
        return this.getBool(KEY_DEBUG_MODE);
    }

    public void setConfigAdsDisabled(boolean configAdsDisabled) {
        this.setBool("dna_config_ads_disabled", configAdsDisabled);
    }

    public boolean getConfigAdsDisabled() {
        return this.getBool("dna_config_ads_disabled", false);
    }

    public void setSearchAdsDisabled(boolean searchAdsDisabled) {
        this.setBool(KEY_CONFIG_SEARCH_ADS_DISABLED, searchAdsDisabled);
    }

    public boolean getSearchAdsDisabled() {
        return this.getBool(KEY_CONFIG_SEARCH_ADS_DISABLED, false);
    }

    public void setSearchInstallAdsDisabled(boolean searchInstallAdsDisabled) {
        this.setBool(KEY_CONFIG_SEARCH_INSTALL_ADS_DISABLED, searchInstallAdsDisabled);
    }

    public boolean getSearchInstallAdsDisabled() {
        return this.getBool(KEY_CONFIG_SEARCH_INSTALL_ADS_DISABLED, false);
    }

    public void setRecomAdsDisabled(boolean recomAdsDisabled) {
        this.setBool(KEY_CONFIG_REC_ADS_DISABLED, recomAdsDisabled);
    }

    public boolean getRecomAdsDisabled() {
        return this.getBool(KEY_CONFIG_REC_ADS_DISABLED, false);
    }

    public void setRecomInstallAdsDisabled(boolean recomInstallAdsDisabled) {
        this.setBool(KEY_CONFIG_REC_INSTALL_ADS_DISABLED, recomInstallAdsDisabled);
    }

    public boolean getRecomInstallAdsDisabled() {
        return this.getBool(KEY_CONFIG_REC_INSTALL_ADS_DISABLED, false);
    }

    public void setConfigGAIDDisabled(boolean configGAIDDisabled) {
        this.setBool("dna_config_ads_disabled", configGAIDDisabled);
    }

    public boolean getConfigGAIDDisabled() {
        return this.getBool("dna_config_ads_disabled", false);
    }

    public String getCarrierValue() {
        return this.getString(KEY_CONFIG_CARRIER_VALUE, "none");
    }

    public void setCarrierValue(String carrierValue) {
        this.setString(KEY_CONFIG_CARRIER_VALUE, carrierValue);
    }

    public void setConfigAppUsageDisabled(boolean configAppUsageDisabled) {
        this.setBool("dna_config_ads_disabled", configAppUsageDisabled);
    }

    public boolean getConfigAppUsageDisabled() {
        return this.getBool("dna_config_ads_disabled", false);
    }

    public void setConfigCountryOverride(String configCountryOverride) {
        this.setString(KEY_CONFIG_COUNTRY_OVERRIDE, configCountryOverride);
    }

    public String getConfigCountryOverride() {
        return this.getString(KEY_CONFIG_COUNTRY_OVERRIDE, null);
    }

    public void setLastWakeTime(long wakeTime) {
        this.setLong(KEY_LAST_WAKE_TIME, wakeTime);
    }

    public long getLastWakeTime() {
        return this.getLong(KEY_LAST_WAKE_TIME, 0L);
    }

    public void setLastApiSyncTime(long syncTime) {
        this.setLong(KEY_LAST_API_SYNC_TIME, syncTime);
    }

    public long getLastApiSyncTime() {
        return this.getLong(KEY_LAST_API_SYNC_TIME, 0L);
    }

    public void setLastUsageSyncTime(long syncTime) {
        this.setLong(KEY_LAST_USAGE_SYNC_TIME, syncTime);
    }

    public long getLastUsageSyncTime() {
        return this.getLong(KEY_LAST_USAGE_SYNC_TIME, 0L);
    }

    public static void setUserAgent(Context context, String userAgent) {
        AtomicFile atomicFile = new AtomicFile(new File(context.getFilesDir(), USER_AGENT_SHARED_PREF_FILE));
        FileOutputStream fos = null;
        try {
            fos = atomicFile.startWrite();
            fos.write(userAgent.getBytes("UTF-8"));
            atomicFile.finishWrite(fos);
        }
        catch (IOException e) {
            if (fos != null) {
                atomicFile.failWrite(fos);
            }
            DNALogger.i("Error writing user agent to file: " + e.getMessage());
        }
    }

    public String getUserAgent(Context context) {
        String userAgent = this.getString(KEY_USER_AGENT, "");
        if (userAgent.isEmpty()) {
            AtomicFile atomicFile = new AtomicFile(new File(context.getFilesDir(), USER_AGENT_SHARED_PREF_FILE));
            try {
                String line;
                FileInputStream fis = atomicFile.openRead();
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                BufferedReader reader = new BufferedReader(isr);
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                userAgent = sb.toString();
                this.setString(KEY_USER_AGENT, userAgent);
            }
            catch (FileNotFoundException e) {
                DNALogger.i("User agent file not found: " + e.getMessage());
            }
            catch (IOException e) {
                DNALogger.i("Error reading user agent from file" + e.getMessage());
            }
        }
        return userAgent;
    }

    public void setTimeout(int timeout) {
        this.setInteger(KEY_TIMEOUT, timeout);
    }

    public int getTimeout() {
        return this.getInteger(KEY_TIMEOUT, 5500);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.setInteger(KEY_CONNECT_TIMEOUT, connectTimeout);
    }

    public int getConnectTimeout() {
        return this.getInteger(KEY_CONNECT_TIMEOUT, 10000);
    }

    public void setRetryCount(int retry) {
        this.setInteger(KEY_RETRY_COUNT, retry);
    }

    public int getRetryCount() {
        return this.getInteger(KEY_RETRY_COUNT, 3);
    }

    public void setRetryInterval(int retryInt) {
        this.setInteger(KEY_RETRY_INTERVAL, retryInt);
    }

    public int getRetryInterval() {
        return this.getInteger(KEY_RETRY_INTERVAL, 1000);
    }

    public void resetDataLoaded() {
        this.setBool(KEY_APPS_LOADED, false);
        this.setBool(KEY_SHORTCUTS_LOADED, false);
    }

    public void setAppsLoaded() {
        this.setBool(KEY_APPS_LOADED, true);
    }

    public boolean areAppsLoaded() {
        return this.getBool(KEY_APPS_LOADED);
    }

    public void setAppsNeedReload() {
        this.setBool(KEY_REQUEST_APP_RELOAD, true);
    }

    public void setAppsReloaded() {
        this.setBool(KEY_REQUEST_APP_RELOAD, false);
    }

    public boolean getAppsNeedReload() {
        return this.getBool(KEY_REQUEST_APP_RELOAD, false);
    }

    public void setShortcutsLoaded() {
        this.setBool(KEY_SHORTCUTS_LOADED, true);
    }

    public boolean areShortcutsLoaded() {
        return this.getBool(KEY_SHORTCUTS_LOADED);
    }

    public void setDeviceStartTime(long time) {
        this.setLong(KEY_START_TIME, time);
    }

    public long getDeviceStartTime() {
        return this.getLong(KEY_START_TIME, 0L);
    }

    public void setCPUCount(int count) {
        this.setInteger(KEY_CPU_COUNT, count);
    }

    public int getCPUCount() {
        return this.getInteger(KEY_CPU_COUNT, 0);
    }

    public void setMaxMemory(long memory) {
        this.setLong(KEY_MAX_MEMORY, memory);
    }

    public long getMaxMemory() {
        return this.getLong(KEY_MAX_MEMORY, 0L);
    }

    public void setAndroidVersion(String version) {
        this.setString(KEY_ANDROID_VERSION, version);
    }

    public String getAndroidVersion() {
        return this.getString(KEY_ANDROID_VERSION, "");
    }

    public void setDeviceModel(String model) {
        this.setString(KEY_DEVICE_MODE, model);
    }

    public String getDeviceModel() {
        return this.getString(KEY_DEVICE_MODE, "");
    }

    public void setAppVersion(String version) {
        this.setString(KEY_APP_VERSION, version);
    }

    public String getAppVersion() {
        return this.getString(KEY_APP_VERSION, "");
    }

    public void setAppPackageName(String packageName) {
        this.setString(KEY_APP_PACKAGE_NAME, packageName);
    }

    public String getAppPackageName() {
        return this.getString(KEY_APP_PACKAGE_NAME, "");
    }

    public void setDeviceKey(String key) {
        String currentKey = this.getString(KEY_DEVICE_KEY, "");
        if (!currentKey.equals(key)) {
            this.prefsEditor_.clear();
            this.setString(KEY_DEVICE_KEY, key);
        }
    }

    public String getDeviceKey() {
        return this.getString(KEY_DEVICE_KEY, "");
    }

    public void setSessionID(String session_id) {
        this.setString(KEY_SESSION_ID, session_id);
    }

    public String getSessionID() {
        return this.getString(KEY_SESSION_ID, "");
    }

    public void setRefreshInterval(int refresh_interval) {
        this.setInteger(KEY_REFRESH_INTERVAL, refresh_interval);
    }

    public int getRefreshInterval() {
        return this.getInteger(KEY_REFRESH_INTERVAL, 3600000);
    }

    public void setLocalRefreshInterval(int refresh_interval) {
        this.setInteger(KEY_LOCAL_REFRESH_INTERVAL, refresh_interval);
    }

    public int getLocalRefreshInterval() {
        return this.getInteger(KEY_LOCAL_REFRESH_INTERVAL, 3600000);
    }

    public void setAdSelectionCode(String ad_selection_code) {
        this.setString(KEY_AD_SELECTION_CODE, ad_selection_code);
    }

    public String getAdSelectionCode() {
        return this.getString(KEY_AD_SELECTION_CODE, "");
    }

    public void setCodeVersionID(String code_version_id) {
        this.setString(KEY_CODE_VERSION_ID, code_version_id);
    }

    public String getCodeVersionID() {
        return this.getString(KEY_CODE_VERSION_ID, "");
    }

    public void setAdBundleID(String ad_bundle_id) {
        this.setString(KEY_AD_BUNDLE_ID, ad_bundle_id);
    }

    public String getAdBundleID() {
        return this.getString(KEY_AD_BUNDLE_ID, "");
    }

    public void setMetadataVersionID(String metadata_version_id) {
        this.setString(KEY_METADATA_VERSION_ID, metadata_version_id);
    }

    public String getMetadataVersionID() {
        return this.getString(KEY_METADATA_VERSION_ID, "");
    }

    public void setBlacklistVersionID(String blacklist_version_id) {
        this.setString(KEY_BLACKLIST_VERSION_ID, blacklist_version_id);
    }

    public String getBlacklistVersionID() {
        return this.getString(KEY_BLACKLIST_VERSION_ID, "");
    }

    public void setBlacklistPackages(List<String> blacklistPackages) {
        this.saveStringList(KEY_BLACKLIST_APPS, blacklistPackages);
    }

    public List<String> getBlacklistPackages() {
        return this.getStringList(KEY_BLACKLIST_APPS);
    }

    public void setReplaceGooglePlayUrl(boolean replaceGooglePlayUrl) {
        this.setBool(KEY_REPLACE_GOOGLE_PLAY_URL, replaceGooglePlayUrl);
    }

    public boolean getReplaceGooglePlayUrl() {
        return this.getBool(KEY_REPLACE_GOOGLE_PLAY_URL, false);
    }

    public void setGooglePlayUrlReplacement(String playStoreUrlReplacement) {
        this.setString(KEY_PLAY_STORE_REPLACEMENT_URL, playStoreUrlReplacement);
    }

    public String getGooglePlayUrlReplacement() {
        return this.getString(KEY_PLAY_STORE_REPLACEMENT_URL, "");
    }

    public void setVTAEnabled(boolean vta_enabled) {
        this.setBool(KEY_VTA_ENABLED, vta_enabled);
    }

    public boolean getVTAEnabled() {
        return this.getBool(KEY_VTA_ENABLED, true);
    }

    public void setInstallAdsEnabled(boolean install_ads_enabled) {
        this.setBool(KEY_INSTALL_ADS_ENABLED, install_ads_enabled);
    }

    public boolean getInstallAdsEnabled() {
        return this.getBool(KEY_INSTALL_ADS_ENABLED, true);
    }

    public void setWebAdsEnabled(boolean web_ads_enabled) {
        this.setBool(KEY_WEB_ADS_ENABLED, web_ads_enabled);
    }

    public boolean getWebAdsEnabled() {
        return this.getBool(KEY_WEB_ADS_ENABLED, true);
    }

    public void setOrganicAdsEnabled(boolean organic_ads_enabled) {
        this.setBool(KEY_ORGANIC_ADS_ENABLED, organic_ads_enabled);
    }

    public boolean getOrganicAdsEnabled() {
        return this.getBool(KEY_ORGANIC_ADS_ENABLED, true);
    }

    public void setOrganicAdsOnly(boolean organic_ads_only) {
        this.setBool(KEY_ORGANIC_ADS_ONLY, organic_ads_only);
    }

    public boolean getOrganicAdsOnly() {
        return this.getBool(KEY_ORGANIC_ADS_ONLY, false);
    }

    public void setPaidOrganicBoostEnabled(boolean paid_organic_boost_enabled) {
        this.setBool(KEY_PAID_ORGANIC_BOOST_ENABLED, paid_organic_boost_enabled);
    }

    public boolean getPaidOrganicBoostEnabled() {
        return this.getBool(KEY_PAID_ORGANIC_BOOST_ENABLED, false);
    }

    public void setAdidUsageEnabled(boolean adid_usage_enabled) {
        this.setBool(KEY_ADID_USAGE_ENABLED, adid_usage_enabled);
    }

    public boolean getAdidUsageEnabled() {
        return this.getBool(KEY_ADID_USAGE_ENABLED, false);
    }

    public void setAppUsageDisabled(boolean app_usage_disabled) {
        this.setBool(KEY_APP_USAGE_DISABLED, app_usage_disabled);
    }

    public boolean getAppUsageDisabled() {
        return this.getBool(KEY_APP_USAGE_DISABLED, false);
    }

    public void setAutoDeepLinkEnabled(boolean auto_deep_link_enabled) {
        this.setBool(KEY_AUTO_DEEP_LINK_ENABLED, auto_deep_link_enabled);
    }

    public boolean getAutoDeepLinkEnabled() {
        return this.getBool(KEY_AUTO_DEEP_LINK_ENABLED, true);
    }

    public void setAdid(String adid) {
        this.setString(KEY_ADID, adid);
    }

    public String getAdid() {
        return this.getString(KEY_ADID, "");
    }

    public void setAdCacheTimeout(int ad_cache_timeout) {
        this.setInteger(KEY_AD_CACHE_TIMEOUT, ad_cache_timeout);
    }

    public int getAdCacheTimeout() {
        return this.getInteger(KEY_AD_CACHE_TIMEOUT, 3600000);
    }

    public void setImpressionBlackoutWindow(int impression_blackout_window) {
        this.setInteger(KEY_IMPRESSION_BLACKOUT_WINDOW, impression_blackout_window);
    }

    public int getImpressionBlackoutWindow() {
        return this.getInteger(KEY_IMPRESSION_BLACKOUT_WINDOW, 15000);
    }

    public void setUsageStatsEnabled(boolean usage_stats_enabled) {
        this.setBool(KEY_USAGE_STATS_ENABLED, usage_stats_enabled);
    }

    public boolean getUsageStatsEnabled() {
        return this.getBool(KEY_USAGE_STATS_ENABLED);
    }

    public void setFirstUsageRead(boolean first_usage_read) {
        this.setBool(KEY_FIRST_USAGE_READ, first_usage_read);
    }

    public boolean getFirstUsageRead() {
        return this.getBool(KEY_FIRST_USAGE_READ);
    }

    public void setPackageHidden(String packageName, String userId, boolean hidden) {
        Set<String> hiddenPackages = this.getHiddenPackages();
        String key = packageName + "|" + (userId != null ? userId : "");
        if (hidden) {
            hiddenPackages.add(key);
        } else {
            hiddenPackages.remove(key);
        }
        this.prefsEditor_.putStringSet(KEY_HIDDEN_PACKAGES, hiddenPackages).apply();
    }

    public boolean isPackageHidden(String packageName, String userId) {
        Set<String> hiddenPackages = this.getHiddenPackages();
        String key = packageName + "|" + (userId != null ? userId : "");
        return hiddenPackages.contains(key);
    }

    public Set<String> getHiddenPackages() {
        return new HashSet<String>(this.appSharedPrefs_.getStringSet(KEY_HIDDEN_PACKAGES, new HashSet()));
    }

    public void setComponentHidden(String componentName, String userId, boolean hidden) {
        Set<String> hiddenComponents = this.getHiddenComponents();
        String key = componentName + "|" + (userId != null ? userId : "");
        if (hidden) {
            hiddenComponents.add(key);
        } else {
            hiddenComponents.remove(key);
        }
        this.prefsEditor_.putStringSet(KEY_HIDDEN_COMPONENTS, hiddenComponents).apply();
    }

    public boolean isComponentHidden(String componentName, String userId) {
        Set<String> hiddenComponents = this.getHiddenComponents();
        String key = componentName + "|" + (userId != null ? userId : "");
        return hiddenComponents.contains(key);
    }

    public Set<String> getHiddenComponents() {
        return new HashSet<String>(this.appSharedPrefs_.getStringSet(KEY_HIDDEN_COMPONENTS, new HashSet()));
    }

    public int getInteger(String key, int defaultValue) {
        return this.appSharedPrefs_.getInt(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.appSharedPrefs_.getLong(key, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.appSharedPrefs_.getString(key, defaultValue);
    }

    public boolean getBool(String key, boolean defaultValue) {
        return this.appSharedPrefs_.getBoolean(key, defaultValue);
    }

    public boolean getBool(String key) {
        return this.appSharedPrefs_.getBoolean(key, false);
    }

    public void setInteger(String key, int value) {
        this.prefsEditor_.putInt(key, value).apply();
    }

    public void setLong(String key, long value) {
        this.prefsEditor_.putLong(key, value).apply();
    }

    public void setString(String key, String value) {
        this.prefsEditor_.putString(key, value).apply();
    }

    public void commitString(String key, String value) {
        this.prefsEditor_.putString(key, value).commit();
    }

    public void setBool(String key, Boolean value) {
        this.prefsEditor_.putBoolean(key, value.booleanValue()).apply();
    }

    public void saveStringList(String key, List<String> stringList) {
        HashSet<String> stringSet = new HashSet<String>(stringList);
        this.prefsEditor_.putStringSet(key, stringSet).apply();
    }

    public List<String> getStringList(String key) {
        Set stringSet = this.appSharedPrefs_.getStringSet(key, new HashSet());
        return new ArrayList<String>(stringSet);
    }
}

