/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.devicenative.dna.utils.DNALogger;

class DNADatabase
extends SQLiteOpenHelper {
    public static final String DB_NAME = "devicenative.s3db";
    private static final int DB_VERSION = 1;

    DNADatabase(Context context) {
        super(context, DB_NAME, null, 1);
    }

    public void onCreate(SQLiteDatabase database) {
        DNALogger.i("DNADatabase: onCreate called");
        database.execSQL("CREATE TABLE IF NOT EXISTS stats (_id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, packageName TEXT NOT NULL, value INTEGER, metadata TEXT, completedAt INTEGER DEFAULT 0)");
        database.execSQL("CREATE TABLE IF NOT EXISTS events (_id INTEGER PRIMARY KEY AUTOINCREMENT, event TEXT, type TEXT, placement TEXT, resId TEXT, packageName TEXT, completedAt INTEGER DEFAULT 0)");
        database.execSQL("CREATE TABLE IF NOT EXISTS shortcuts (_id INTEGER PRIMARY KEY AUTOINCREMENT, networkId TEXT, name TEXT NOT NULL, description TEXT, packageName TEXT NOT NULL,intentUri TEXT, rank INTEGER DEFAULT -1, source INTEGER DEFAULT 0, updatedAt INTEGER DEFAULT 0)");
        database.execSQL("CREATE TABLE IF NOT EXISTS apps (_id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, packageName TEXT NOT NULL,userId TEXT, component TEXT, aliases TEXT,timeUsedInLast7D INTEGER DEFAULT 0, timeUsedInLast3D INTEGER DEFAULT 0, timeUsedInLast1D INTEGER DEFAULT 0, timeUsedInLast3Y INTEGER DEFAULT 0, installedAt INTEGER DEFAULT 0, updatedAt INTEGER DEFAULT 0, uninstalledAt INTEGER DEFAULT 0, lastTimeInForeground INTEGER DEFAULT 0, lastUsedAt INTEGER DEFAULT 0)");
        database.execSQL("CREATE TABLE IF NOT EXISTS notifs ( _id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, packageName TEXT NOT NULL,description TEXT, sentAt INTEGER DEFAULT 0)");
        database.execSQL("CREATE TABLE IF NOT EXISTS ads ( _id TEXT PRIMARY KEY, appName TEXT NOT NULL, packageName TEXT NOT NULL, type TEXT, creativeSource TEXT, viewThrough INTEGER DEFAULT 0, notPlayStore INTEGER DEFAULT 0, title TEXT, description TEXT, iconUrl TEXT, clickUrl TEXT, destinationUrl TEXT, impressionUrl TEXT, targetingMetadata TEXT DEFAULT '{}')");
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        Log.w((String)"onUpgrade", (String)("Updating database from version " + oldVersion + " to version " + newVersion));
    }

    public void onDowngrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        Log.w((String)"onDowngrade", (String)("Updating database from version " + oldVersion + " to version " + newVersion));
    }
}

